/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.RubyElementVisitor;

public class TestSearchEngine {
    public static IType[] findTests(IFile file) {
        IRubyScript script = RubyCore.create((IFile)file);
        try {
            script.reconcile();
            IRubyElement[] children = script.getChildren();
            ArrayList<IType> types = new ArrayList<IType>();
            int i = 0;
            while (i < children.length) {
                if (children[i].isType(5)) {
                    types.add((IType)children[i]);
                }
                ++i;
            }
            IType[] array = new IType[types.size()];
            System.arraycopy(types.toArray(), 0, array, 0, types.size());
            return array;
        }
        catch (RubyModelException e) {
            RubyPlugin.log((Throwable)e);
            return new IType[0];
        }
    }

    public static IType[] findTests(IProject rubyProject) {
        if (rubyProject == null) {
            return new IType[0];
        }
        try {
            ArrayList<IType> tests = new ArrayList<IType>();
            RubyElementVisitor visitor = new RubyElementVisitor();
            rubyProject.accept((IResourceVisitor)visitor);
            Object[] rubyFiles = visitor.getCollectedRubyFiles();
            int i = 0;
            while (i < rubyFiles.length) {
                IFile rubyFile = (IFile)rubyFiles[i];
                IType[] elements = TestSearchEngine.findTests(rubyFile);
                int j = 0;
                while (j < elements.length) {
                    tests.add(elements[j]);
                    ++j;
                }
                ++i;
            }
            Object[] listArray = tests.toArray();
            IType[] array = new IType[tests.size()];
            System.arraycopy(listArray, 0, array, 0, listArray.length);
            return array;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new IType[0];
        }
    }
}

