/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.testunit.ui.CounterPanel;
import org.rubypeople.rdt.internal.testunit.ui.FailureTrace;
import org.rubypeople.rdt.internal.testunit.ui.ITestRunListener3;
import org.rubypeople.rdt.internal.testunit.ui.ProgressImages;
import org.rubypeople.rdt.internal.testunit.ui.RemoteTestRunnerClient;
import org.rubypeople.rdt.internal.testunit.ui.ScrollLockAction;
import org.rubypeople.rdt.internal.testunit.ui.TabFolderLayout;
import org.rubypeople.rdt.internal.testunit.ui.TestRunInfo;
import org.rubypeople.rdt.internal.testunit.ui.TestRunTab;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitProgressBar;
import org.rubypeople.rdt.internal.testunit.ui.TestunitPlugin;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.testunit.ITestRunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUnitView
extends ViewPart
implements ITestRunListener3 {
    public static final String NAME = "org.rubypeople.rdt.testunit.views.TestUnitView";
    static final int REFRESH_INTERVAL = 200;
    public static final String ID_EXTENSION_POINT_TESTRUN_TABS = "org.rubypeople.rdt.testunit.internalTestRunTabs";
    private VIEW_ORIENTATION fOrientation = VIEW_ORIENTATION.AUTOMATIC;
    private VIEW_ORIENTATION fCurrentOrientation;
    private ToggleOrientationAction[] fToggleOrientationActions;
    final Image fStackViewIcon = TestUnitView.createImage("eview16/stackframe.gif");
    final Image fTestRunOKIcon = TestUnitView.createImage("eview16/testunitsucc.gif");
    final Image fTestRunFailIcon = TestUnitView.createImage("eview16/testuniterr.gif");
    final Image fTestRunOKDirtyIcon = TestUnitView.createImage("eview16/testunitsuccq.gif");
    final Image fTestRunFailDirtyIcon = TestUnitView.createImage("eview16/testuniterrq.gif");
    private TestRunTab fActiveRunTab;
    protected Vector<TestRunTab> fTestRunTabs = new Vector();
    private Map<String, TestRunInfo> fTestInfos = new HashMap<String, TestRunInfo>();
    private boolean fIsDisposed = false;
    private RemoteTestRunnerClient fTestRunnerClient;
    private String fLaunchMode;
    private ILaunch fLastLaunch;
    private Action fRerunLastTestAction;
    protected volatile int fExecutedTests;
    protected volatile int fErrorCount;
    protected volatile int fFailureCount;
    protected volatile int fTestCount;
    private List<TestRunInfo> fFailures = new ArrayList<TestRunInfo>();
    protected boolean fShowOnErrorOnly = false;
    private CounterPanel fCounterPanel;
    private TestUnitProgressBar fProgressBar;
    protected ProgressImages fProgressImages;
    protected Image fViewImage;
    private Composite fCounterComposite;
    private Composite fParent;
    private SashForm fSashForm;
    private CTabFolder fTabFolder;
    private FailureTrace fFailureTrace;
    private Clipboard fClipboard;
    protected volatile String fStatus;
    Image fOriginalViewImage;
    IElementChangedListener fDirtyListener;
    private UpdateUIJob fUpdateJob;
    private boolean fAutoScroll = true;
    private ScrollLockAction fScrollLockAction;
    private IRubyProject fTestProject;
    private IMenuListener fViewMenuListener;
    private ActivateOnErrorAction fActivateOnErrorAction;
    private boolean fIsRunning = false;
    private boolean fIsStopped = false;
    private int fStartedCount = 0;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (TestUnitView.this.getSite().getId().equals(ref.getId())) {
                TestUnitView.this.fPartIsVisible = true;
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (TestUnitView.this.getSite().getId().equals(ref.getId())) {
                TestUnitView.this.fPartIsVisible = false;
            }
        }
    };
    protected boolean fPartIsVisible = false;

    public static Image createImage(String path) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)TestunitPlugin.makeIconFileURL(path));
            return id.createImage();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        this.fClipboard = new Clipboard(parent.getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.configureToolBar();
        this.fCounterComposite = this.createProgressCountPanel(parent);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.fOriginalViewImage = this.getTitleImage();
        this.fProgressImages = new ProgressImages();
        this.getViewSite().getPage().addPartListener(this.fPartListener);
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fRerunLastTestAction = new RerunLastAction();
        this.fScrollLockAction = new ScrollLockAction(this);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fRerunLastTestAction);
        toolBar.add((IAction)this.fScrollLockAction);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, VIEW_ORIENTATION.VERTICAL), new ToggleOrientationAction(this, VIEW_ORIENTATION.HORIZONTAL), new ToggleOrientationAction(this, VIEW_ORIENTATION.AUTOMATIC)};
        MenuManager layoutSubMenu = new MenuManager(TestUnitMessages.TestRunnerViewPart_layout_menu);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.fToggleOrientationActions[i]);
            ++i;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        this.fScrollLockAction.setChecked(!this.fAutoScroll);
        this.fActivateOnErrorAction = new ActivateOnErrorAction();
        viewMenu.add((IAction)this.fActivateOnErrorAction);
        this.fViewMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestUnitView.this.fActivateOnErrorAction.update();
            }
        };
        viewMenu.addMenuListener(this.fViewMenuListener);
        actionBars.updateActionBars();
    }

    private SashForm createSashForm(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.fSashForm, 0);
        this.fTabFolder = this.createTestRunTabs((Composite)top);
        this.fTabFolder.setLayoutData((Object)new TabFolderLayout());
        top.setContent((Control)this.fTabFolder);
        ViewForm bottom = new ViewForm((Composite)this.fSashForm, 0);
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText(TestUnitMessages.TestRunnerViewPart_label_failure);
        label.setImage(this.fStackViewIcon);
        bottom.setTopLeft((Control)label);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fFailureTrace = new FailureTrace((Composite)bottom, this.fClipboard, this, failureToolBar);
        bottom.setContent((Control)this.fFailureTrace.getComposite());
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    protected CTabFolder createTestRunTabs(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.loadTestRunTabs(tabFolder);
        tabFolder.setSelection(0);
        this.fActiveRunTab = this.fTestRunTabs.firstElement();
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestUnitView.this.testTabChanged(event);
            }
        });
        return tabFolder;
    }

    private void testTabChanged(SelectionEvent event) {
        Enumeration<TestRunTab> e = this.fTestRunTabs.elements();
        while (e.hasMoreElements()) {
            TestRunTab v = e.nextElement();
            if (((CTabFolder)event.widget).getSelection().getText() != v.getName()) continue;
            v.setSelectedTest(this.fActiveRunTab.getSelectedTestId());
            this.fActiveRunTab = v;
            this.fActiveRunTab.activate();
        }
    }

    private void loadTestRunTabs(CTabFolder tabFolder) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_TESTRUN_TABS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus("org.rubypeople.rdt.testunit", 0, "Could not load some testRunTabs extension points", null);
        int i = 0;
        while (i < configs.length) {
            try {
                TestRunTab testRunTab = (TestRunTab)configs[i].createExecutableExtension("class");
                testRunTab.createTabControl(tabFolder, this.fClipboard, this);
                this.fTestRunTabs.addElement(testRunTab);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            TestunitPlugin.log((IStatus)status);
        }
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setCounterColumns(layout);
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new TestUnitProgressBar(composite);
        this.fProgressBar.setLayoutData(new GridData(768));
        return composite;
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == VIEW_ORIENTATION.HORIZONTAL ? 2 : 1;
    }

    public void setFocus() {
        if (this.fActiveRunTab != null) {
            this.fActiveRunTab.setFocus();
        }
    }

    public void showTest(TestRunInfo test) {
        this.fActiveRunTab.setSelectedTest(test.getTestId());
        this.handleTestSelected(test.getTestId());
    }

    public void handleTestSelected(String testId) {
        TestRunInfo testInfo = this.getTestInfo(testId);
        if (testInfo == null) {
            this.showFailure(null);
        } else {
            this.showFailure(testInfo);
        }
    }

    public TestRunInfo getTestInfo(String testId) {
        if (testId == null) {
            return null;
        }
        return this.fTestInfos.get(testId);
    }

    private void showFailure(final TestRunInfo failure) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestUnitView.this.isDisposed()) {
                    TestUnitView.this.fFailureTrace.showFailure(failure);
                }
            }
        });
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        this.stopTest();
        if (this.fProgressImages != null) {
            this.fProgressImages.dispose();
        }
        this.fTestRunOKIcon.dispose();
        this.fTestRunFailIcon.dispose();
        this.fStackViewIcon.dispose();
        this.fTestRunOKDirtyIcon.dispose();
        this.fTestRunFailDirtyIcon.dispose();
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
    }

    public void rerunTest(String testId, String className, String testName, String launchMode) {
        DebugUITools.saveAndBuildBeforeLaunch();
        if (this.lastLaunchIsKeptAlive()) {
            this.fTestRunnerClient.rerunTest(testId, className, testName);
        } else if (this.fLastLaunch != null) {
            ILaunchConfiguration launchConfiguration = this.fLastLaunch.getLaunchConfiguration();
            if (launchConfiguration != null) {
                try {
                    String name = className;
                    if (testName != null) {
                        name = String.valueOf(name) + "." + testName;
                    }
                    String configName = TestUnitMessages.getFormattedString(TestUnitMessages.TestRunnerViewPart_configName, name);
                    ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy(configName);
                    tmp.setAttribute("org.rubypeople.rdt.testunit.TESTTYPE", className);
                    if (testName != null) {
                        tmp.setAttribute("org.rubypeople.rdt.testunit.TESTNAME", testName);
                    }
                    tmp.launch(launchMode, null);
                    return;
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)TestUnitMessages.TestRunnerViewPart_error_cannotrerun, (String)e.getMessage(), (IStatus)e.getStatus());
                }
            }
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)TestUnitMessages.TestRunnerViewPart_cannotrerun_title, (String)TestUnitMessages.TestRunnerViewPart_cannotrerurn_message);
        }
    }

    public boolean lastLaunchIsKeptAlive() {
        return this.fTestRunnerClient != null && this.fTestRunnerClient.isRunning() && "debug".equals(this.fLaunchMode);
    }

    public void startTestRunListening(int port, IType type, ILaunch launch, Set<ITestRunListener> testRunListeners) {
        if (type != null) {
            this.fTestProject = type.getRubyProject();
        } else {
            try {
                String projectName = launch.getLaunchConfiguration().getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                this.fTestProject = RubyModelManager.getRubyModelManager().getRubyModel().getRubyProject(projectName);
            }
            catch (CoreException e) {
                TestunitPlugin.log(e);
            }
        }
        this.fLaunchMode = launch.getLaunchMode();
        this.aboutToLaunch();
        if (this.fTestRunnerClient != null) {
            this.stopTest();
        }
        this.fTestRunnerClient = new RemoteTestRunnerClient();
        ITestRunListener[] listenerArray = new ITestRunListener[testRunListeners.size() + 1];
        listenerArray[0] = this;
        Iterator<ITestRunListener> iter = testRunListeners.iterator();
        int i = 0;
        while (i < testRunListeners.size()) {
            listenerArray[i + 1] = iter.next();
            ++i;
        }
        this.fTestRunnerClient.startListening(listenerArray, port);
        this.fLastLaunch = launch;
        this.setViewPartTitle((IRubyElement)type);
        if (type instanceof IType) {
            this.setTitleToolTip(type.getFullyQualifiedName());
        } else if (type != null) {
            this.setTitleToolTip(type.getElementName());
        }
    }

    protected void aboutToLaunch() {
        String msg = TestUnitMessages.TestRunnerViewPart_message_launching;
        this.showInformation(msg);
        this.setInfoMessage(msg);
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    protected void showInformation(final String info) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestUnitView.this.isDisposed()) {
                    TestUnitView.this.fFailureTrace.setInformation(info);
                }
            }
        });
    }

    protected void setInfoMessage(String message) {
        this.fStatus = message;
    }

    public void stopTest() {
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        this.stopUpdateJob();
    }

    private void stopUpdateJob() {
        if (this.fUpdateJob != null) {
            this.fUpdateJob.stop();
            this.fUpdateJob = null;
        }
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public boolean isCreated() {
        return this.fCounterPanel != null;
    }

    public void reset() {
        this.reset(0);
        this.setViewPartTitle(null);
        this.clearStatus();
        this.resetViewIcon();
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    private void resetViewIcon() {
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    private void setViewPartTitle(IRubyElement type) {
        String title = type == null ? " " : (type instanceof IType ? ((IType)type).getFullyQualifiedName() : type.getElementName());
        this.setContentDescription(title);
    }

    private void reset(final int testCount) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.fCounterPanel.reset();
                TestUnitView.this.fFailureTrace.clear();
                TestUnitView.this.fProgressBar.reset();
                TestUnitView.this.clearStatus();
                TestUnitView.this.start(testCount);
            }
        });
        this.fExecutedTests = 0;
        this.fFailureCount = 0;
        this.fErrorCount = 0;
        this.fTestCount = testCount;
        this.fIsRunning = false;
        this.fIsStopped = false;
        this.fStartedCount = 0;
        this.aboutToStart();
        this.fTestInfos.clear();
        this.fFailures = new ArrayList<TestRunInfo>();
    }

    protected void start(int total) {
        this.resetProgressBar(total);
        this.fCounterPanel.setTotal(total);
        this.fCounterPanel.setRunValue(0);
    }

    private void resetProgressBar(int total) {
        this.fProgressBar.reset();
        this.fProgressBar.setMaximum(total);
    }

    private void aboutToStart() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestUnitView.this.isDisposed()) {
                    Enumeration<TestRunTab> e = TestUnitView.this.fTestRunTabs.elements();
                    while (e.hasMoreElements()) {
                        TestRunTab v = e.nextElement();
                        v.aboutToStart();
                    }
                }
            }
        });
    }

    @Override
    public void testEnded(String testId, String testName) {
        this.postEndTest(testId, testName);
        ++this.fExecutedTests;
    }

    @Override
    public void testFailed(int status, String testId, String testName, String trace) {
        this.testFailed(status, testId, testName, trace, null, null);
    }

    @Override
    public void testFailed(int status, String testId, String testName, String trace, String expected, String actual) {
        TestRunInfo testInfo = this.getTestInfo(testId);
        if (testInfo == null) {
            testInfo = new TestRunInfo(testId, testName);
            this.fTestInfos.put(testName, testInfo);
        }
        testInfo.setTrace(trace);
        testInfo.setStatus(status);
        if (expected != null) {
            testInfo.setExpected(expected.substring(0, expected.length() - 1));
        }
        if (actual != null) {
            testInfo.setActual(actual.substring(0, actual.length() - 1));
        }
        if (status == 1) {
            ++this.fErrorCount;
        } else {
            ++this.fFailureCount;
        }
        this.fFailures.add(testInfo);
        if (this.fShowOnErrorOnly && this.fErrorCount + this.fFailureCount == 1) {
            this.postShowTestResultsView();
        }
    }

    protected void postShowTestResultsView() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.showTestResultsView();
            }
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        TestUnitView testRunner = null;
        if (page != null) {
            try {
                testRunner = (TestUnitView)page.findView(NAME);
                if (testRunner == null) {
                    IWorkbenchPart activePart = page.getActivePart();
                    testRunner = (TestUnitView)page.showView(NAME);
                    page.activate(activePart);
                } else {
                    page.bringToTop((IWorkbenchPart)testRunner);
                }
            }
            catch (PartInitException pie) {
                TestunitPlugin.log(pie);
            }
        }
    }

    @Override
    public void testReran(String testId, String className, String testName, int status, String trace) {
        String msg;
        if (status == 1) {
            msg = TestUnitMessages.getFormattedString(TestUnitMessages.TestRunnerViewPart_message_error, new String[]{testName, className});
            this.postError(msg);
        } else if (status == 2) {
            msg = TestUnitMessages.getFormattedString(TestUnitMessages.TestRunnerViewPart_message_failure, new String[]{testName, className});
            this.postError(msg);
        } else {
            msg = TestUnitMessages.getFormattedString(TestUnitMessages.TestRunnerViewPart_message_success, new String[]{testName, className});
            this.setInfoMessage(msg);
        }
        TestRunInfo info = this.getTestInfo(testId);
        this.updateTest(info, status);
        if (info.getTrace() == null || !info.getTrace().equals(trace)) {
            info.setTrace(trace);
            this.showFailure(info);
        }
    }

    protected void postError(String message) {
        this.fStatus = message;
    }

    private void updateTest(TestRunInfo info, int status) {
        if (status == info.getStatus()) {
            return;
        }
        if (info.getStatus() == 0) {
            if (status == 2) {
                ++this.fFailureCount;
            } else if (status == 1) {
                ++this.fErrorCount;
            }
        } else if (info.getStatus() == 1) {
            if (status == 0) {
                --this.fErrorCount;
            } else if (status == 2) {
                --this.fErrorCount;
                ++this.fFailureCount;
            }
        } else if (info.getStatus() == 2) {
            if (status == 0) {
                --this.fFailureCount;
            } else if (status == 1) {
                --this.fFailureCount;
                ++this.fErrorCount;
            }
        }
        info.setStatus(status);
        final TestRunInfo finalInfo = info;
        this.postSyncRunnable(new Runnable(){

            public void run() {
                Enumeration<TestRunTab> e = TestUnitView.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = e.nextElement();
                    v.testStatusChanged(finalInfo);
                }
            }
        });
    }

    @Override
    public void testReran(String testId, String className, String testName, int statusCode, String trace, String expectedResult, String actualResult) {
        this.testReran(testId, className, testName, statusCode, trace);
        TestRunInfo info = this.getTestInfo(testId);
        info.setActual(actualResult);
        info.setExpected(expectedResult);
        this.fFailureTrace.updateEnablement(info);
    }

    private void postEndTest(final String testId, String testName) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.handleEndTest();
                Enumeration<TestRunTab> e = TestUnitView.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = e.nextElement();
                    v.endTest(testId);
                }
            }
        });
    }

    private void handleEndTest() {
        Image progress;
        this.fProgressBar.step(this.fFailureCount + this.fErrorCount);
        if (this.fShowOnErrorOnly && (progress = this.fProgressImages.getImage(this.fExecutedTests, this.fTestCount, this.fErrorCount, this.fFailureCount)) != this.fViewImage) {
            this.fViewImage = progress;
            this.firePropertyChange(1);
        }
    }

    public void setShowOnErrorOnly(boolean showOnErrorOnly) {
        this.fShowOnErrorOnly = showOnErrorOnly;
    }

    public boolean getShowOnErrorOnly() {
        return this.fShowOnErrorOnly;
    }

    @Override
    public void testStarted(String testId, String testName) {
        TestRunInfo testInfo;
        this.postStartTest(testId, testName);
        if (!this.fShowOnErrorOnly && this.fExecutedTests == 1) {
            this.postShowTestResultsView();
        }
        if ((testInfo = this.getTestInfo(testId)) == null) {
            testInfo = new TestRunInfo(testId, testName);
            this.fTestInfos.put(testId, testInfo);
        }
        String className = testInfo.getClassName();
        String method = testInfo.getTestMethodName();
        String status = TestUnitMessages.getFormattedString(TestUnitMessages.TestRunnerViewPart_message_started, new String[]{className, method});
        this.setInfoMessage(status);
        ++this.fStartedCount;
    }

    private void postStartTest(final String testId, String testName) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                Enumeration<TestRunTab> e = TestUnitView.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = e.nextElement();
                    v.startTest(testId);
                }
            }
        });
    }

    @Override
    public void testRunStopped(long elapsedTime) {
        this.setInfoMessage(TestUnitMessages.TestRunnerViewPart_message_stopped);
        this.handleStopped();
        this.fIsRunning = false;
        this.fIsStopped = true;
    }

    private void handleStopped() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.resetViewIcon();
                TestUnitView.this.fProgressBar.stopped();
            }
        });
        this.stopUpdateJob();
    }

    @Override
    public void testRunEnded(long elapsedTime) {
        --this.fExecutedTests;
        this.fIsRunning = false;
        Object[] keys = new String[]{this.elapsedTimeAsString(elapsedTime)};
        String msg = TestUnitMessages.getFormattedString(TestUnitMessages.TestRunnerViewPart_message_finish, keys);
        if (this.hasErrorsOrFailures()) {
            this.postError(msg);
        } else {
            this.setInfoMessage(msg);
        }
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                if (TestUnitView.this.fFailures.size() > 0) {
                    TestUnitView.this.selectFirstFailure();
                }
                TestUnitView.this.updateViewIcon();
                if (TestUnitView.this.fDirtyListener == null) {
                    TestUnitView.this.fDirtyListener = new DirtyListener();
                    RubyCore.addElementChangedListener((IElementChangedListener)TestUnitView.this.fDirtyListener);
                }
                Enumeration<TestRunTab> e = TestUnitView.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = e.nextElement();
                    v.aboutToEnd();
                }
            }
        });
        this.stopUpdateJob();
    }

    private String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    private boolean hasErrorsOrFailures() {
        return this.fErrorCount + this.fFailureCount > 0;
    }

    protected void selectFirstFailure() {
        TestRunInfo firstFailure = this.fFailures.get(0);
        if (firstFailure != null && this.fAutoScroll) {
            this.fActiveRunTab.setSelectedTest(firstFailure.getTestId());
            this.handleTestSelected(firstFailure.getTestId());
        }
    }

    @Override
    public void testRunTerminated() {
        String msg = TestUnitMessages.TestRunnerViewPart_message_terminated;
        this.showMessage(msg);
        this.handleStopped();
        this.fIsRunning = false;
        this.fIsStopped = true;
    }

    private void showMessage(String msg) {
        this.postError(msg);
    }

    @Override
    public void testRunStarted(int testCount) {
        this.reset(testCount);
        ++this.fExecutedTests;
        this.stopUpdateJob();
        this.fUpdateJob = new UpdateUIJob(TestUnitMessages.TestRunnerViewPart_jobName);
        this.fUpdateJob.schedule(200L);
        this.fIsRunning = true;
    }

    private void refreshCounters() {
        this.fCounterPanel.setErrorValue(this.fErrorCount);
        this.fCounterPanel.setFailureValue(this.fFailureCount);
        this.fCounterPanel.setRunValue(this.fExecutedTests);
        this.fProgressBar.refresh(this.fErrorCount + this.fFailureCount > 0);
    }

    protected void doShowStatus() {
        this.setContentDescription(this.fStatus);
    }

    @Override
    public void testTreeEntry(final String treeEntry) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                Enumeration<TestRunTab> e = TestUnitView.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = e.nextElement();
                    v.newTreeEntry(treeEntry);
                }
            }
        });
    }

    public void rerunTestRun() {
        if (this.lastLaunchIsKeptAlive() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)TestUnitMessages.TestRunnerViewPart_terminate_title, (String)TestUnitMessages.TestRunnerViewPart_terminate_message) && this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        if (this.fLastLaunch != null && this.fLastLaunch.getLaunchConfiguration() != null) {
            DebugUITools.launch((ILaunchConfiguration)this.fLastLaunch.getLaunchConfiguration(), (String)this.fLastLaunch.getLaunchMode());
        }
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TestUnitView.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        if (this.fOrientation != VIEW_ORIENTATION.AUTOMATIC) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(VIEW_ORIENTATION.HORIZONTAL);
                } else {
                    this.setOrientation(VIEW_ORIENTATION.VERTICAL);
                }
            }
        }
    }

    private void setOrientation(VIEW_ORIENTATION orientation) {
        if (this.fSashForm == null || this.fSashForm.isDisposed()) {
            return;
        }
        boolean horizontal = orientation == VIEW_ORIENTATION.HORIZONTAL;
        this.fSashForm.setOrientation(horizontal ? 256 : 512);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.fCounterComposite.getLayout();
        this.setCounterColumns(layout);
        this.fParent.layout();
    }

    public IRubyProject getLaunchedProject() {
        return this.fTestProject;
    }

    public ILaunch getLastLaunch() {
        return this.fLastLaunch;
    }

    private void processChangesInUI() {
        if (this.fSashForm.isDisposed()) {
            return;
        }
        this.doShowStatus();
        this.refreshCounters();
        if (!this.fPartIsVisible) {
            this.updateViewTitleProgress();
        } else {
            this.updateViewIcon();
        }
    }

    private void updateViewIcon() {
        this.fViewImage = this.fIsStopped || this.fIsRunning || this.fStartedCount == 0 ? this.fOriginalViewImage : (this.hasErrorsOrFailures() ? this.fTestRunFailIcon : this.fTestRunOKIcon);
        this.firePropertyChange(1);
    }

    public Image getTitleImage() {
        if (this.fOriginalViewImage == null) {
            this.fOriginalViewImage = super.getTitleImage();
        }
        if (this.fViewImage == null) {
            return super.getTitleImage();
        }
        return this.fViewImage;
    }

    private void updateViewTitleProgress() {
        if (this.fIsRunning) {
            Image progress = this.fProgressImages.getImage(this.fStartedCount, this.fTestCount, this.fErrorCount, this.fFailureCount);
            if (progress != this.fViewImage) {
                this.fViewImage = progress;
                this.firePropertyChange(1);
            }
        } else {
            this.updateViewIcon();
        }
    }

    void codeHasChanged() {
        if (this.fDirtyListener != null) {
            RubyCore.removeElementChangedListener((IElementChangedListener)this.fDirtyListener);
            this.fDirtyListener = null;
        }
        if (this.fViewImage == this.fTestRunOKIcon) {
            this.fViewImage = this.fTestRunOKDirtyIcon;
        } else if (this.fViewImage == this.fTestRunFailIcon) {
            this.fViewImage = this.fTestRunFailDirtyIcon;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.firePropertyChange(1);
            }
        };
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(r);
        }
    }

    private class ActivateOnErrorAction
    extends Action {
        public ActivateOnErrorAction() {
            super(TestUnitMessages.TestRunnerViewPart_activate_on_failure_only, 2);
            this.update();
        }

        public void update() {
            this.setChecked(TestUnitView.this.getShowOnErrorOnly());
        }

        public void run() {
            boolean checked;
            TestUnitView.this.fShowOnErrorOnly = checked = this.isChecked();
            IPreferenceStore store = TestunitPlugin.getDefault().getPreferenceStore();
            store.setValue("org.rubypeople.rdt.testunit.show_on_error", checked);
        }
    }

    private class DirtyListener
    implements IElementChangedListener {
        private DirtyListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.processDelta(event.getDelta());
        }

        private boolean processDelta(IRubyElementDelta delta) {
            int kind = delta.getKind();
            int details = delta.getFlags();
            int type = delta.getElement().getElementType();
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (kind == 4 && details == 8) break;
                    TestUnitView.this.codeHasChanged();
                    return false;
                }
                case 4: {
                    if ((details & 0x10000) != 0) {
                        return true;
                    }
                    TestUnitView.this.codeHasChanged();
                    return false;
                }
                default: {
                    TestUnitView.this.codeHasChanged();
                    return false;
                }
            }
            IRubyElementDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren == null) {
                return true;
            }
            int i = 0;
            while (i < affectedChildren.length) {
                if (!this.processDelta(affectedChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class RerunLastAction
    extends Action {
        public RerunLastAction() {
            this.setText(TestUnitMessages.TestRunnerViewPart_rerunaction_label);
            this.setToolTipText(TestUnitMessages.TestRunnerViewPart_rerunaction_tooltip);
            this.setDisabledImageDescriptor(TestunitPlugin.getImageDescriptor("dlcl16/relaunch.gif"));
            this.setHoverImageDescriptor(TestunitPlugin.getImageDescriptor("elcl16/relaunch.gif"));
            this.setImageDescriptor(TestunitPlugin.getImageDescriptor("elcl16/relaunch.gif"));
        }

        public void run() {
            TestUnitView.this.rerunTestRun();
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final VIEW_ORIENTATION fActionOrientation;

        public ToggleOrientationAction(TestUnitView v, VIEW_ORIENTATION orientation) {
            super("", 8);
            if (orientation == VIEW_ORIENTATION.HORIZONTAL) {
                this.setText(TestUnitMessages.TestRunnerViewPart_toggle_horizontal_label);
                this.setImageDescriptor(TestunitPlugin.getImageDescriptor("elcl16/th_horizontal.gif"));
            } else if (orientation == VIEW_ORIENTATION.VERTICAL) {
                this.setText(TestUnitMessages.TestRunnerViewPart_toggle_vertical_label);
                this.setImageDescriptor(TestunitPlugin.getImageDescriptor("elcl16/th_vertical.gif"));
            } else if (orientation == VIEW_ORIENTATION.AUTOMATIC) {
                this.setText(TestUnitMessages.TestRunnerViewPart_toggle_automatic_label);
                this.setImageDescriptor(TestunitPlugin.getImageDescriptor("elcl16/th_automatic.gif"));
            }
            this.fActionOrientation = orientation;
        }

        public VIEW_ORIENTATION getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestUnitView.this.fOrientation = this.fActionOrientation;
                TestUnitView.this.computeOrientation();
            }
        }
    }

    class UpdateUIJob
    extends UIJob {
        private boolean fRunning;

        public UpdateUIJob(String name) {
            super(name);
            this.fRunning = true;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TestUnitView.this.isDisposed()) {
                TestUnitView.this.processChangesInUI();
            }
            this.schedule(200L);
            return Status.OK_STATUS;
        }

        public void stop() {
            this.fRunning = false;
        }

        public boolean shouldSchedule() {
            return this.fRunning;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VIEW_ORIENTATION {
        VERTICAL,
        HORIZONTAL,
        AUTOMATIC;

    }
}

