/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.db.internal.ui.editors.sql.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.radrails.db.core.DatabaseManager;
import org.radrails.db.core.ProjectDatabaseManager;
import org.radrails.db.core.QueryAdministrator;

public class SQLExecuteHelper {
    private static SQLExecuteHelper instance;

    private SQLExecuteHelper() {
    }

    public static SQLExecuteHelper getInstance() {
        if (instance == null) {
            instance = new SQLExecuteHelper();
        }
        return instance;
    }

    public boolean runSQLFile(IFile file, String env) throws FileNotFoundException, SQLException, InstantiationException, IllegalAccessException, IOException, CoreException {
        String r;
        IProject project = file.getProject();
        ProjectDatabaseManager pdm = DatabaseManager.getInstance().getProjectDatabaseManager(project);
        BufferedReader in = new BufferedReader(new InputStreamReader(file.getContents()));
        StringBuffer buffer = new StringBuffer();
        boolean inBlockComment = false;
        while ((r = in.readLine()) != null) {
            if (r.startsWith("/*") && !inBlockComment) {
                inBlockComment = true;
                continue;
            }
            if (r.startsWith("*/") && inBlockComment) {
                inBlockComment = false;
                continue;
            }
            if (r.endsWith("*/") && inBlockComment) {
                inBlockComment = false;
                continue;
            }
            if (r.length() <= 0 || r.trim().startsWith("--") || inBlockComment) continue;
            buffer.append(r);
        }
        in.close();
        return this.executeStatements(pdm.getConnection(env), buffer.toString());
    }

    private boolean executeStatements(Connection conn, String statements) throws SQLException {
        boolean successful = false;
        QueryAdministrator query = new QueryAdministrator(conn);
        String[] statementArray = this.parseStatementsString(statements);
        int i = 0;
        while (i < statementArray.length) {
            query.executeStatement(statementArray[i]);
            ++i;
        }
        return successful;
    }

    private String[] parseStatementsString(String statements) {
        statements = statements.replaceAll("\n", "");
        return statements.split(";");
    }
}

