/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseCharacterStreamWrapper;
import com.microsoft.jdbc.base.BaseClobInputStream;
import com.microsoft.jdbc.base.BaseClobOutputStream;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplChunkedClob;
import com.microsoft.jdbc.base.BaseImplClob;
import com.microsoft.jdbc.base.BaseImplClobService;
import com.microsoft.jdbc.base.BaseImplSearchableClob;
import com.microsoft.jdbc.base.BaseInputStreamWrapper;
import com.microsoft.util.UtilDataConversions;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTransliterator;
import com.microsoft.util.UtilTransliteratorForASCII;
import com.microsoft.util.UtilTransliteratorForUCS2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class BaseClob
implements Clob {
    private static String footprint = "$Revision:   1.11.1.0  $";
    private BaseImplClob implClob;
    private Object lastInputStream;
    private Object lastOutputStream;
    private boolean deferSearchEmulation;
    private UtilTransliterator transliterator;
    BaseConnection connection;
    Object synchronizer;
    BaseExceptions exceptions;

    public BaseClob(BaseImplClob baseImplClob, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        this(baseImplClob, baseConnection, true, baseExceptions);
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public BaseClob(BaseImplClob baseImplClob, BaseConnection baseConnection, boolean bl, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert("Must supply a native Clob implementation", baseImplClob != null);
        UtilDebug.assert("Must supply a BaseExceptions object", baseExceptions != null);
        this.implClob = baseImplClob;
        this.deferSearchEmulation = bl;
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.chainInClobServices();
    }

    private void chainInClobServices() throws SQLException {
        int n = new Long(this.implClob.getMaxChunkSize()).intValue();
        if (n > 0) {
            this.implClob = new BaseImplChunkedClob(n, this.implClob, this.exceptions);
        }
        if (!this.deferSearchEmulation && !this.implClob.supportsSearch()) {
            this.implClob = new BaseImplSearchableClob(this.implClob, this.exceptions);
        }
    }

    protected void close() throws SQLException {
        if (!this.verifyOpen()) {
            return;
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.closeLastInputStream();
            this.closeLastOutputStream();
            try {
                try {
                    this.implClob.close();
                }
                catch (SQLException sQLException) {
                    throw this.exceptions.getException(6064);
                }
                Object var4_2 = null;
                this.implClob = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.implClob = null;
                throw throwable;
            }
        }
    }

    private void closeLastInputStream() {
        if (this.lastInputStream != null) {
            try {
                if (this.lastInputStream instanceof InputStream) {
                    ((InputStream)this.lastInputStream).close();
                } else if (this.lastInputStream instanceof Reader) {
                    ((Reader)this.lastInputStream).close();
                } else {
                    UtilDebug.assert("Invalid lastInputStream object", false);
                }
            }
            catch (IOException iOException) {}
            this.lastInputStream = null;
        }
    }

    private void closeLastOutputStream() {
        if (this.lastOutputStream != null) {
            try {
                if (this.lastOutputStream instanceof OutputStream) {
                    ((OutputStream)this.lastOutputStream).close();
                } else if (this.lastOutputStream instanceof Writer) {
                    ((Writer)this.lastOutputStream).close();
                } else {
                    UtilDebug.assert("Invalid lastOutputStream object", false);
                }
            }
            catch (IOException iOException) {}
            this.lastOutputStream = null;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {}
    }

    public InputStream getAsciiStream() throws SQLException {
        InputStream inputStream = null;
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            BaseClobInputStream baseClobInputStream = new BaseClobInputStream(this.implClob, this.exceptions);
            long l = this.implClob.getLength();
            try {
                inputStream = this.getTransliterator().decodeAsAsciiStream(baseClobInputStream);
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException(utilException);
            }
            inputStream = new BaseInputStreamWrapper(inputStream, l, this.connection, this.exceptions);
            this.setLastInputStream(inputStream);
            InputStream inputStream2 = inputStream;
            Object var4_7 = null;
            return inputStream2;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        Reader reader = null;
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            BaseClobInputStream baseClobInputStream = new BaseClobInputStream(this.implClob, this.exceptions);
            long l = this.implClob.getLength();
            try {
                reader = this.getTransliterator().decodeAsReader(baseClobInputStream);
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException(utilException);
            }
            reader = new BaseCharacterStreamWrapper(reader, l, this.connection, this.exceptions);
            this.setLastInputStream(reader);
            Reader reader2 = reader;
            Object var4_7 = null;
            return reader2;
        }
    }

    public BaseImplClob getNativeImplClob() {
        BaseImplClob baseImplClob = this.implClob;
        while (baseImplClob instanceof BaseImplClobService) {
            baseImplClob = ((BaseImplClobService)baseImplClob).getChainedImplClob();
        }
        return baseImplClob;
    }

    public String getSubString(long l, int n) throws SQLException {
        if (l <= 0L || n < 0) {
            String[] stringArray = new String[]{"Clob.getSubString"};
            throw this.exceptions.getException(6070, stringArray);
        }
        Object object = this.synchronizer;
        synchronized (object) {
            String string;
            this.validateClosedState();
            long l2 = this.length();
            if (l > l2) {
                throw this.exceptions.getException(6078);
            }
            if (l - 1L + (long)n > l2) {
                try {
                    n = new Long(l2 - (l - 1L)).intValue();
                }
                catch (Exception exception) {
                    throw this.exceptions.getException(6066);
                }
            }
            int n2 = this.implClob.getCharacterEncoding();
            switch (n2) {
                case 1: {
                    byte[] byArray = new byte[n];
                    int n3 = this.implClob.readData(byArray, 0, l, n);
                    string = UtilDataConversions.ASCIIBytesToString(byArray, n3);
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[n * 2];
                    int n4 = this.implClob.readData(byArray, 0, l, n);
                    string = UtilDataConversions.UCS2BytesToString(byArray, n4);
                    break;
                }
                default: {
                    throw this.exceptions.getException(6025);
                }
            }
            String string2 = string;
            Object var12_13 = null;
            return string2;
        }
    }

    private UtilTransliterator getTransliterator() throws SQLException {
        if (this.transliterator == null) {
            switch (this.implClob.getCharacterEncoding()) {
                case 1: {
                    this.transliterator = new UtilTransliteratorForASCII();
                    break;
                }
                case 2: {
                    this.transliterator = new UtilTransliteratorForUCS2();
                    break;
                }
                default: {
                    throw this.exceptions.getException(6025);
                }
            }
        }
        return this.transliterator;
    }

    public long length() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            long l = this.implClob.getLength();
            Object var4_3 = null;
            return l;
        }
    }

    public long position(String string, long l) throws SQLException {
        if (string == null || l <= 0L) {
            String[] stringArray = new String[]{"Clob.position"};
            throw this.exceptions.getException(6070, stringArray);
        }
        if (l >= this.length()) {
            throw this.exceptions.getException(6078);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInClobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            long l2 = this.implClob.find(string, l);
            Object var7_6 = null;
            return l2;
        }
    }

    public long position(Clob clob, long l) throws SQLException {
        if (clob == null || l <= 0L) {
            String[] stringArray = new String[]{"Clob.position"};
            throw this.exceptions.getException(6070, stringArray);
        }
        if (l >= this.length()) {
            throw this.exceptions.getException(6078);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInClobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            int n;
            this.validateClosedState();
            try {
                n = new Long(clob.length()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6065);
            }
            long l2 = this.implClob.find(clob.getSubString(1L, n), l);
            Object var7_7 = null;
            return l2;
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            if (l <= 0L) {
                String[] stringArray = new String[]{"setAsciiStream"};
                throw this.exceptions.getException(6070, stringArray);
            }
            BaseClobOutputStream baseClobOutputStream = new BaseClobOutputStream(this.implClob, l, this.synchronizer, this.exceptions);
            baseClobOutputStream.setAsciiStream(true);
            this.setLastOutputStream(baseClobOutputStream);
            BaseClobOutputStream baseClobOutputStream2 = baseClobOutputStream;
            Object var5_6 = null;
            return baseClobOutputStream2;
        }
    }

    public Writer setCharacterStream(long l) throws SQLException {
        OutputStreamWriter outputStreamWriter = null;
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            if (l <= 0L) {
                String[] stringArray = new String[]{"setCharacterStream"};
                throw this.exceptions.getException(6070, stringArray);
            }
            BaseClobOutputStream baseClobOutputStream = new BaseClobOutputStream(this.implClob, l, this.synchronizer, this.exceptions);
            baseClobOutputStream.setAsciiStream(false);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)baseClobOutputStream, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.exceptions.getException(6025);
            }
            this.setLastOutputStream(outputStreamWriter);
            OutputStreamWriter outputStreamWriter2 = outputStreamWriter;
            Object var6_7 = null;
            return outputStreamWriter2;
        }
    }

    private void setLastInputStream(Object object) {
        this.closeLastInputStream();
        this.lastInputStream = object;
    }

    private void setLastOutputStream(Object object) {
        this.closeLastOutputStream();
        this.lastOutputStream = object;
    }

    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            if (n2 == 0) {
                int n3 = 0;
                Object var8_8 = null;
                return n3;
            }
            if (l <= 0L || n < 0 || n + n2 > string.length()) {
                String[] stringArray = new String[]{"setString"};
                throw this.exceptions.getException(6070, stringArray);
            }
            int n4 = this.implClob.getCharacterEncoding();
            byte[] byArray = null;
            int n5 = -1;
            try {
                byArray = string.getBytes(BaseImplClob.getEncodingName(n4));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw this.exceptions.getException(6025);
            }
            switch (n4) {
                case 1: {
                    n5 = this.implClob.writeData(l, byArray, n, n2);
                    break;
                }
                case 2: {
                    n5 = this.implClob.writeData(l, byArray, n * 2, n2);
                    break;
                }
                default: {
                    throw this.exceptions.getException(6025);
                }
            }
            int n6 = n5;
            Object var8_9 = null;
            return n6;
        }
    }

    public String toString() {
        try {
            int n = 4000;
            int n2 = new Long(this.length()).intValue();
            if (n2 > n) {
                n2 = n;
            }
            return this.getSubString(1L, n2);
        }
        catch (SQLException sQLException) {
            return this.exceptions.getException(6025).getMessage();
        }
    }

    public void truncate(long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            if (l < 0L || l > this.length()) {
                String[] stringArray = new String[]{"truncate"};
                throw this.exceptions.getException(6070, stringArray);
            }
            this.implClob.truncate(l);
        }
    }

    void validateClosedState() throws SQLException {
        if (this.connection != null) {
            this.connection.validateClosedState();
        }
        if (!this.verifyOpen()) {
            throw this.exceptions.getException(6010);
        }
    }

    private boolean verifyOpen() {
        return this.implClob != null;
    }
}

