/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseBlobInputStream;
import com.microsoft.jdbc.base.BaseBlobOutputStream;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplBlob;
import com.microsoft.jdbc.base.BaseImplBlobService;
import com.microsoft.jdbc.base.BaseImplChunkedBlob;
import com.microsoft.jdbc.base.BaseImplSearchableBlob;
import com.microsoft.jdbc.base.BaseInputStreamWrapper;
import com.microsoft.util.UtilDataConversions;
import com.microsoft.util.UtilDebug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BaseBlob
implements Blob {
    private static String footprint = "$Revision:   1.11.1.0  $";
    private BaseImplBlob implBlob;
    private InputStream lastInputStream;
    private OutputStream lastOutputStream;
    private boolean deferSearchEmulation;
    BaseConnection connection;
    Object synchronizer;
    BaseExceptions exceptions;

    public BaseBlob(BaseImplBlob baseImplBlob, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        this(baseImplBlob, baseConnection, true, baseExceptions);
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public BaseBlob(BaseImplBlob baseImplBlob, BaseConnection baseConnection, boolean bl, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert("Must supply a native Blob implementation", baseImplBlob != null);
        UtilDebug.assert("Must supply a BaseExceptions object", baseExceptions != null);
        this.implBlob = baseImplBlob;
        this.deferSearchEmulation = bl;
        this.exceptions = baseExceptions;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
        this.chainInBlobServices();
    }

    private void chainInBlobServices() throws SQLException {
        int n = new Long(this.implBlob.getMaxChunkSize()).intValue();
        if (n > 0) {
            this.implBlob = new BaseImplChunkedBlob(n, this.implBlob, this.exceptions);
        }
        if (!this.deferSearchEmulation && !this.implBlob.supportsSearch()) {
            this.implBlob = new BaseImplSearchableBlob(this.implBlob, this.exceptions);
        }
    }

    protected void close() throws SQLException {
        if (!this.verifyOpen()) {
            return;
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.setLastInputStream(null);
            this.setLastOutputStream(null);
            try {
                try {
                    this.implBlob.close();
                }
                catch (SQLException sQLException) {
                    throw this.exceptions.getException(6064);
                }
                Object var4_2 = null;
                this.implBlob = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.implBlob = null;
                throw throwable;
            }
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {}
    }

    public InputStream getBinaryStream() throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            BaseBlobInputStream baseBlobInputStream = new BaseBlobInputStream(this.implBlob, this.exceptions);
            long l = this.implBlob.getLength();
            baseInputStreamWrapper = new BaseInputStreamWrapper(baseBlobInputStream, l, this.connection, this.exceptions);
            this.setLastInputStream(baseInputStreamWrapper);
            InputStream inputStream = this.lastInputStream;
            Object var4_6 = null;
            return inputStream;
        }
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l <= 0L || n < 0) {
            String[] stringArray = new String[]{"Blob.getBytes"};
            throw this.exceptions.getException(6070, stringArray);
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            long l2 = this.length();
            if (l > l2) {
                throw this.exceptions.getException(6078);
            }
            if (l - 1L + (long)n > l2) {
                try {
                    n = new Long(l2 - (l - 1L)).intValue();
                }
                catch (Exception exception) {
                    this.exceptions.getException(6066);
                }
            }
            byte[] byArray = new byte[n];
            this.implBlob.readData(byArray, 0, l, n);
            byte[] byArray2 = byArray;
            Object var6_8 = null;
            return byArray2;
        }
    }

    public BaseImplBlob getNativeImplBlob() {
        BaseImplBlob baseImplBlob = this.implBlob;
        while (baseImplBlob instanceof BaseImplBlobService) {
            baseImplBlob = ((BaseImplBlobService)baseImplBlob).getChainedImplBlob();
        }
        return baseImplBlob;
    }

    public long length() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            long l = this.implBlob.getLength();
            Object var4_3 = null;
            return l;
        }
    }

    public long position(Blob blob, long l) throws SQLException {
        if (blob == null || l <= 0L) {
            String[] stringArray = new String[]{"Blob.position"};
            throw this.exceptions.getException(6070, stringArray);
        }
        if (l >= this.length()) {
            throw this.exceptions.getException(6078);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInBlobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            int n;
            this.validateClosedState();
            try {
                n = new Long(blob.length()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6065);
            }
            long l2 = this.implBlob.find(blob.getBytes(1L, n), l);
            Object var7_7 = null;
            return l2;
        }
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (byArray == null || l <= 0L) {
            String[] stringArray = new String[]{"Blob.position"};
            throw this.exceptions.getException(6070, stringArray);
        }
        if (l >= this.length()) {
            throw this.exceptions.getException(6078);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInBlobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            long l2 = this.implBlob.find(byArray, l);
            Object var7_6 = null;
            return l2;
        }
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            if (l <= 0L) {
                String[] stringArray = new String[]{"setBinaryStream"};
                throw this.exceptions.getException(6070, stringArray);
            }
            BaseBlobOutputStream baseBlobOutputStream = new BaseBlobOutputStream(this.implBlob, l, this.synchronizer, this.exceptions);
            this.setLastOutputStream(baseBlobOutputStream);
            BaseBlobOutputStream baseBlobOutputStream2 = baseBlobOutputStream;
            Object var5_6 = null;
            return baseBlobOutputStream2;
        }
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            if (n2 == 0) {
                int n3 = 0;
                Object var8_8 = null;
                return n3;
            }
            if (l <= 0L || n < 0 || n + n2 > byArray.length) {
                String[] stringArray = new String[]{"setBytes"};
                throw this.exceptions.getException(6070, stringArray);
            }
            int n4 = this.implBlob.writeData(l, byArray, n, n2);
            Object var8_9 = null;
            return n4;
        }
    }

    void setConnection(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.synchronizer = baseConnection;
    }

    private void setLastInputStream(InputStream inputStream) {
        if (this.lastInputStream != null) {
            try {
                this.lastInputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.lastInputStream = inputStream;
    }

    private void setLastOutputStream(OutputStream outputStream) {
        if (this.lastOutputStream != null) {
            try {
                this.lastOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.lastOutputStream = outputStream;
    }

    public String toString() {
        try {
            int n = 4000;
            int n2 = new Long(this.length()).intValue();
            if (n2 > n / 2) {
                n2 = n / 2;
            }
            byte[] byArray = this.getBytes(1L, n2);
            return UtilDataConversions.bytesToString(byArray, byArray.length);
        }
        catch (SQLException sQLException) {
            return this.exceptions.getException(6025).getMessage();
        }
    }

    public void truncate(long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            if (l < 0L || l > this.length()) {
                String[] stringArray = new String[]{"truncate"};
                throw this.exceptions.getException(6070, stringArray);
            }
            this.implBlob.truncate(l);
        }
    }

    void validateClosedState() throws SQLException {
        if (this.connection != null) {
            this.connection.validateClosedState();
        }
        if (!this.verifyOpen()) {
            throw this.exceptions.getException(6010);
        }
    }

    private boolean verifyOpen() {
        return this.implBlob != null;
    }
}

