/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.parser.warnings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.SyntaxException;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.parser.warnings.DeprecatedActiveRecordFindMethods;
import org.radrails.rails.internal.parser.warnings.DeprecatedImageLinkMethods;
import org.radrails.rails.internal.parser.warnings.DeprecatedPostFormatMethods;
import org.radrails.rails.internal.parser.warnings.DeprecatedRedirectCalls;
import org.radrails.rails.internal.parser.warnings.DeprecatedRenderCalls;
import org.radrails.rails.internal.parser.warnings.DeprecatedStartAndEndFormTag;
import org.radrails.rails.internal.parser.warnings.DeprecatedUpdateElementFunction;
import org.radrails.rails.internal.parser.warnings.HumanSizeHelperAlias;
import org.radrails.rails.internal.parser.warnings.InternalInstanceVariableReference;
import org.radrails.rails.internal.parser.warnings.PushWithAttributes;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.CompilationParticipant;
import org.rubypeople.rdt.core.compiler.ReconcileContext;
import org.rubypeople.rdt.core.parser.warnings.DelegatingVisitor;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsDeprecationParticipant
extends CompilationParticipant {
    public void reconcile(ReconcileContext context) {
        try {
            if (!RailsPlugin.hasRailsNature(context.getWorkingCopy().getRubyProject().getProject())) {
                return;
            }
            List<CategorizedProblem> problems = this.parse(context.getWorkingCopy().getElementName(), context.getWorkingCopy().getSource(), context.getAST());
            this.addProblems(context, "org.rubypeople.rdt.core.problem", problems);
        }
        catch (RubyModelException e) {
            RailsLog.log((CoreException)((Object)e));
        }
    }

    private List<CategorizedProblem> parse(String name, String contents, RootNode ast) {
        if (ast == null) {
            try {
                RubyParser parser = new RubyParser();
                ast = (RootNode)parser.parse(name, contents).getAST();
            }
            catch (SyntaxException syntaxException) {
            }
            catch (RuntimeException e) {
                RailsLog.log(e);
            }
        }
        if (ast == null) {
            return new ArrayList<CategorizedProblem>();
        }
        DelegatingVisitor visitor = new DelegatingVisitor(this.createLintVisitors(contents));
        ast.accept((NodeVisitor)visitor);
        return visitor.getProblems();
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        super.buildStarting(files, isBatch);
        int i = 0;
        while (i < files.length) {
            BuildContext context = files[i];
            if (RailsPlugin.hasRailsNature(context.getFile().getProject())) {
                List<CategorizedProblem> problems = this.parse(context.getFile().getName(), new String(context.getContents()), null);
                context.recordNewProblems(problems.toArray(new CategorizedProblem[problems.size()]));
            }
            ++i;
        }
    }

    public boolean isActive(IRubyProject project) {
        return RailsPlugin.hasRailsNature(project.getProject());
    }

    private List<RubyLintVisitor> createLintVisitors(String contents) {
        ArrayList<RubyLintVisitor> visitors = new ArrayList<RubyLintVisitor>();
        visitors.add(new InternalInstanceVariableReference());
        visitors.add(new DeprecatedRenderCalls());
        visitors.add(new DeprecatedRedirectCalls());
        visitors.add(new DeprecatedPostFormatMethods());
        visitors.add(new DeprecatedStartAndEndFormTag());
        visitors.add(new DeprecatedUpdateElementFunction());
        visitors.add(new DeprecatedImageLinkMethods());
        visitors.add(new HumanSizeHelperAlias());
        visitors.add(new DeprecatedActiveRecordFindMethods());
        visitors.add(new PushWithAttributes());
        ArrayList<RubyLintVisitor> filtered = new ArrayList<RubyLintVisitor>();
        for (RubyLintVisitor visitor : visitors) {
            if (visitor.isIgnored()) continue;
            filtered.add(visitor);
        }
        return filtered;
    }
}

