/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.parser.warnings;

import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.InstVarNode;
import org.jruby.evaluator.Instruction;
import org.radrails.rails.internal.core.RailsPlugin;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class InternalInstanceVariableReference
extends RubyLintVisitor {
    private boolean inController = false;
    private static final String[] DEPRECATED = new String[]{"@params", "@session", "@flash", "@request", "@cookies", "@headers", "@response"};

    public InternalInstanceVariableReference() {
        super(RailsPlugin.getInstance().getOptions(), "");
    }

    protected int getProblemID() {
        return 519;
    }

    protected String getOptionKey() {
        return "org.radrails.rails.core.compiler.problem.railsInstanceVariable";
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        Colon3Node node = iVisited.getCPath();
        String name = node.getName();
        if (name.endsWith("Controller")) {
            this.inController = true;
        }
        return super.visitClassNode(iVisited);
    }

    public void exitClassNode(ClassNode iVisited) {
        this.inController = false;
        super.exitClassNode(iVisited);
    }

    public Instruction visitInstVarNode(InstVarNode iVisited) {
        if (this.inController) {
            String name = iVisited.getName();
            int i = 0;
            while (i < DEPRECATED.length) {
                if (name.equals(DEPRECATED[i])) {
                    this.createProblem(iVisited.getPosition(), "Rails Deprecation notice: change references from " + DEPRECATED[i] + " to " + DEPRECATED[i].substring(1));
                    break;
                }
                ++i;
            }
        }
        return super.visitInstVarNode(iVisited);
    }
}

