/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.parser.warnings;

import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.jruby.evaluator.Instruction;
import org.radrails.rails.internal.core.RailsPlugin;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class DeprecatedActiveRecordFindMethods
extends RubyLintVisitor {
    private static final String ACTIVE_RECORD_BASE = "ActiveRecord::Base";
    private static final String[] DEPRECATED = new String[]{"find_first", "find_all"};
    private static final String[] SOLUTIONS = new String[]{"find(:first)", "find(:all)"};
    private boolean inActiveRecord;

    public DeprecatedActiveRecordFindMethods() {
        super(RailsPlugin.getInstance().getOptions(), "");
    }

    protected int getProblemID() {
        return 514;
    }

    protected String getOptionKey() {
        return "org.radrails.rails.core.compiler.problem.railsDeprecationActiveRecordFindMethods";
    }

    public Instruction visitCallNode(CallNode iVisited) {
        String name = iVisited.getName();
        int i = 0;
        while (i < DEPRECATED.length) {
            Node receiver;
            if (name.equals(DEPRECATED[i]) && (receiver = iVisited.getReceiverNode()) instanceof ConstNode) {
                this.createProblem(iVisited.getPosition(), "Deprecated method, use " + SOLUTIONS[i] + " instead");
                break;
            }
            ++i;
        }
        return super.visitCallNode(iVisited);
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        Node superNode = iVisited.getSuperNode();
        String superName = ASTUtil.getSuperClassName((Node)superNode);
        if (superName != null && superName.equals(ACTIVE_RECORD_BASE)) {
            this.inActiveRecord = true;
        }
        return super.visitClassNode(iVisited);
    }

    public void exitClassNode(ClassNode iVisited) {
        this.inActiveRecord = false;
        super.exitClassNode(iVisited);
    }

    public Instruction visitVCallNode(VCallNode iVisited) {
        this.checkForDeprecatedCalls((INameNode)iVisited);
        return super.visitVCallNode(iVisited);
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        this.checkForDeprecatedCalls((INameNode)iVisited);
        return super.visitFCallNode(iVisited);
    }

    private void checkForDeprecatedCalls(INameNode iVisited) {
        if (!this.inActiveRecord) {
            return;
        }
        if (iVisited == null) {
            return;
        }
        String name = iVisited.getName();
        if (name == null || name.trim().length() == 0) {
            return;
        }
        int i = 0;
        while (i < DEPRECATED.length) {
            if (name.equals(DEPRECATED[i])) {
                this.createProblem(((Node)iVisited).getPosition(), "Deprecated method, use " + SOLUTIONS[i] + " instead");
                break;
            }
            ++i;
        }
    }
}

