/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.generators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.generators.Generator;
import org.radrails.rails.internal.generators.GeneratorsLocator;
import org.radrails.rails.internal.generators.RailsGemGeneratorLocator;
import org.radrails.rails.internal.generators.VendorGeneratorsLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorLocatorsManager {
    private static GeneratorLocatorsManager instance = null;
    private static Map<IProject, List<GeneratorsLocator>> projectGeneratorLocators;

    private GeneratorLocatorsManager() {
        projectGeneratorLocators = new HashMap<IProject, List<GeneratorsLocator>>();
        Set<IProject> projects = RailsPlugin.getRailsProjects();
        for (IProject project : projects) {
            this.addLocatorsForProject(project);
        }
    }

    private List<GeneratorsLocator> addLocatorsForProject(IProject project) {
        ArrayList<GeneratorsLocator> locators = new ArrayList<GeneratorsLocator>();
        locators.add(new VendorGeneratorsLocator(project));
        locators.add(new RailsGemGeneratorLocator(project));
        projectGeneratorLocators.put(project, locators);
        return locators;
    }

    public static GeneratorLocatorsManager getInstance() {
        if (instance == null) {
            instance = new GeneratorLocatorsManager();
        }
        return instance;
    }

    public List<Generator> getAllGenerators(IProject currentProject) {
        ArrayList<Generator> generators = new ArrayList<Generator>();
        if (currentProject != null) {
            List<GeneratorsLocator> locators = this.getLocators(currentProject);
            for (GeneratorsLocator locator : locators) {
                locator.locateGenerators();
                generators.addAll(locator.getLocatedGenerators());
            }
        }
        return generators;
    }

    private List<GeneratorsLocator> getLocators(IProject currentProject) {
        List<GeneratorsLocator> locators = projectGeneratorLocators.get(currentProject);
        if (locators == null) {
            locators = this.addLocatorsForProject(currentProject);
        }
        return locators;
    }
}

