/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.radrails.rails.internal.core.RailsPlugin;

public class RailsLog {
    public static void logInfo(String message, Throwable e) {
        RailsLog.log(RailsLog.createStatus(1, 0, message, e));
    }

    public static void logWarning(String message, Throwable e) {
        RailsLog.log(RailsLog.createStatus(2, 0, message, e));
    }

    public static void logError(String message, Throwable e) {
        if (message == null) {
            if (e == null) {
                message = "";
            } else {
                message = e.getMessage();
                if (message == null) {
                    message = "";
                }
            }
        }
        RailsLog.log(RailsLog.createStatus(4, 0, message, e));
    }

    protected static IStatus createStatus(int severity, int code, String message, Throwable exception) {
        return new Status(severity, RailsPlugin.getInstance().getBundle().getSymbolicName(), code, message, exception);
    }

    protected static void log(IStatus status) {
        RailsPlugin.getInstance().getLog().log(status);
    }

    public static void log(CoreException e) {
        RailsPlugin.getInstance().getLog().log(e.getStatus());
    }

    public static void log(String info) {
        RailsPlugin.getInstance().getLog().log(RailsLog.createStatus(1, -1, info, null));
    }

    public static void log(Exception e) {
        RailsLog.logError(e.getLocalizedMessage(), e);
    }
}

