/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.core;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.radrails.rails.core.Inflector;
import org.radrails.rails.internal.core.RailsPlugin;

public abstract class RailsConventions {
    private static final String APP = "app";
    private static final String RB = ".rb";
    private static final String MODELS = "models";
    private static final String VIEWS = "views";
    private static final String CONTROLLERS = "controllers";
    private static final String HELPERS = "helpers";
    private static final String TEST = "test";
    private static final String FUNCTIONAL = "functional";
    private static final String UNIT = "unit";
    private static final String CONTROLLER_SUFFIX = "_controller";
    private static final String CONTROLLER_FILE_SUFFIX = "_controller.rb";
    private static final String TEST_SUFFIX = "_test";
    private static final String FUNCTIONAL_TEST_SUFFIX = "_controller_test.rb";
    private static final String UNIT_TEST_SUFFIX = "_test.rb";
    private static final String HELPER_SUFFIX = "_helper";
    private static final String HELPER_FILE_SUFFIX = "_helper.rb";

    public static IFile getModelFromController(IFile controllerFile) {
        if (!RailsConventions.looksLikeController(controllerFile)) {
            return null;
        }
        IPath controllerFilePath = controllerFile.getProjectRelativePath();
        String controllerFilename = controllerFilePath.lastSegment();
        IPath model = RailsConventions.getModelFromController(controllerFilePath, RailsConventions.getModelName(controllerFilename));
        IFile file = controllerFile.getProject().getFile(model);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static IFile getControllerFromModel(IFile modelFile) {
        IPath modelFilePath = modelFile.getProjectRelativePath();
        String modelFilename = modelFilePath.lastSegment();
        if (!RailsConventions.looksLikeModel(modelFile)) {
            return null;
        }
        String singular = modelFilename.substring(0, modelFilename.indexOf(46));
        String plural = Inflector.pluralize(singular);
        String controllerName = String.valueOf(plural) + CONTROLLER_FILE_SUFFIX;
        IPath controllerPath = RailsConventions.buildController(RailsConventions.getAppFolderFromModel(modelFilePath), controllerName);
        IFile file = modelFile.getProject().getFile(controllerPath);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static String getModelName(String controllerFilename) {
        String singular = Inflector.singularize(RailsConventions.getControllerBaseName(controllerFilename));
        singular = String.valueOf(singular) + RB;
        return singular;
    }

    private static IPath getModelFromController(IPath controllerFilePath, String singular) {
        return RailsConventions.getAppFolderFromController(controllerFilePath).append(MODELS).append(singular);
    }

    private static IPath getModelFromHelper(IPath helperFilePath, String singular) {
        return RailsConventions.getAppFolderFromHelper(helperFilePath).append(MODELS).append(singular);
    }

    private static String getControllerBaseName(String controllerFilename) {
        return controllerFilename.substring(0, controllerFilename.length() - CONTROLLER_FILE_SUFFIX.length());
    }

    public static IFile getModelFromView(IFile viewFile) {
        if (!RailsConventions.looksLikeView(viewFile)) {
            return null;
        }
        IPath viewFilePath = viewFile.getProjectRelativePath();
        IPath model = RailsConventions.getModelFromView(viewFilePath);
        return viewFile.getProject().getFile(model);
    }

    public static boolean looksLikeView(IFile file) {
        if (file == null) {
            return false;
        }
        IPath railsRoot = RailsPlugin.findRailsRoot(file.getProject());
        if (!railsRoot.isPrefixOf(file.getProjectRelativePath())) {
            return false;
        }
        IPath afterRoot = file.getProjectRelativePath().removeFirstSegments(railsRoot.segmentCount());
        return afterRoot.segment(0).equals(APP) && afterRoot.segment(1).equals(VIEWS);
    }

    private static String getModelNameFromViewPath(IPath viewFilePath) {
        String singular = Inflector.singularize(RailsConventions.getPluralResourceNameFromViewPath(viewFilePath));
        singular = String.valueOf(singular) + RB;
        return singular;
    }

    private static String getPluralResourceNameFromViewPath(IPath viewFilePath) {
        IFile viewFile = ResourcesPlugin.getWorkspace().getRoot().getFile(viewFilePath);
        IPath railsRoot = RailsPlugin.findRailsRoot(viewFile.getProject());
        IPath appViews = railsRoot.append(APP).append(VIEWS);
        return viewFilePath.removeFirstSegments(appViews.segmentCount()).removeLastSegments(1).toPortableString();
    }

    private static IPath getModelFromView(IPath viewFilePath) {
        String singular = RailsConventions.getModelNameFromViewPath(viewFilePath);
        return RailsConventions.getAppFolderFromView(viewFilePath).append(MODELS).append(singular);
    }

    public static IFile getControllerFromView(IFile viewFile) {
        if (!RailsConventions.looksLikeView(viewFile)) {
            return null;
        }
        IPath railsRoot = RailsPlugin.findRailsRoot(viewFile.getProject());
        IPath viewFilePath = viewFile.getProjectRelativePath();
        String plural = RailsConventions.getPluralResourceNameFromViewPath(viewFilePath);
        String[] namespace = RailsConventions.getControllerNamespace(viewFilePath);
        String controllerName = String.valueOf(new Path(plural).lastSegment()) + CONTROLLER_FILE_SUFFIX;
        IPath controllerPath = railsRoot.append(APP).append(CONTROLLERS);
        int i = 0;
        while (i < namespace.length) {
            controllerPath = controllerPath.append(namespace[i]);
            ++i;
        }
        controllerPath = controllerPath.append(controllerName);
        IFile file = viewFile.getProject().getFile(controllerPath);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static IPath buildController(IPath appFolder, String controllerName) {
        return appFolder.append(CONTROLLERS).append(controllerName);
    }

    private static IPath getAppFolderFromView(IPath viewFilePath) {
        String[] segments = viewFilePath.segments();
        int i = 0;
        while (i < segments.length) {
            if (segments[i].equals(APP)) {
                return viewFilePath.uptoSegment(i + 1);
            }
            ++i;
        }
        return viewFilePath.removeLastSegments(3);
    }

    private static IPath getAppFolderFromController(IPath controllerFilePath) {
        return controllerFilePath.removeLastSegments(2);
    }

    private static IPath getAppFolderFromModel(IPath modelFilePath) {
        return modelFilePath.removeLastSegments(2);
    }

    public static IFile getFunctionalTestFromView(IFile viewFile) {
        if (!RailsConventions.looksLikeView(viewFile)) {
            return null;
        }
        IPath viewFilePath = viewFile.getProjectRelativePath();
        String plural = RailsConventions.getPluralResourceNameFromViewPath(viewFilePath);
        IPath functionalTestPath = RailsConventions.buildFunctionalTest(RailsConventions.getAppFolderFromView(viewFilePath), plural);
        return viewFile.getProject().getFile(functionalTestPath);
    }

    private static IPath buildFunctionalTest(IPath appFolder, String plural) {
        return appFolder.removeLastSegments(1).append(TEST).append(FUNCTIONAL).append(String.valueOf(plural) + FUNCTIONAL_TEST_SUFFIX);
    }

    public static boolean looksLikeController(IFile currentFile) {
        if (currentFile == null) {
            return false;
        }
        String name = currentFile.getName();
        return name.endsWith(CONTROLLER_FILE_SUFFIX);
    }

    public static boolean looksLikeHelper(IFile currentFile) {
        if (currentFile == null) {
            return false;
        }
        String name = currentFile.getName();
        return name.endsWith(HELPER_FILE_SUFFIX);
    }

    public static IFile getHelperFromModel(IFile modelFile) {
        IPath modelFilePath = modelFile.getProjectRelativePath();
        String modelFilename = modelFilePath.lastSegment();
        if (!RailsConventions.looksLikeModel(modelFile)) {
            return null;
        }
        String singular = modelFilename.substring(0, modelFilename.indexOf(46));
        String plural = Inflector.pluralize(singular);
        String helperName = String.valueOf(plural) + HELPER_FILE_SUFFIX;
        IPath helperPath = RailsConventions.buildHelper(RailsConventions.getAppFolderFromModel(modelFilePath), helperName);
        IFile file = modelFile.getProject().getFile(helperPath);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static IPath buildHelper(IPath appFolder, String helperName) {
        return appFolder.append(HELPERS).append(helperName);
    }

    public static IFile getHelperFromView(IFile viewFile) {
        if (!RailsConventions.looksLikeView(viewFile)) {
            return null;
        }
        IPath viewFilePath = viewFile.getProjectRelativePath();
        String plural = RailsConventions.getPluralResourceNameFromViewPath(viewFilePath);
        IPath helperPath = RailsConventions.buildHelper(RailsConventions.getAppFolderFromView(viewFilePath), String.valueOf(plural) + HELPER_FILE_SUFFIX);
        IFile file = viewFile.getProject().getFile(helperPath);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static IFile getHelperFromController(IFile controllerFile) {
        if (!RailsConventions.looksLikeController(controllerFile)) {
            return null;
        }
        IPath controllerFilePath = controllerFile.getProjectRelativePath();
        String controllerFilename = controllerFilePath.lastSegment();
        String plural = RailsConventions.getControllerBaseName(controllerFilename);
        String helperName = String.valueOf(plural) + HELPER_FILE_SUFFIX;
        IPath helperPath = RailsConventions.buildHelper(RailsConventions.getAppFolderFromController(controllerFilePath), helperName);
        IFile file = controllerFile.getProject().getFile(helperPath);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static IFile getControllerFromHelper(IFile helperFile) {
        if (!RailsConventions.looksLikeHelper(helperFile)) {
            return null;
        }
        IPath helperFilePath = helperFile.getProjectRelativePath();
        String plural = RailsConventions.getPluralResourceNameFromHelperPath(helperFilePath.lastSegment());
        String controllerName = String.valueOf(plural) + CONTROLLER_FILE_SUFFIX;
        IPath controllerPath = RailsConventions.buildController(RailsConventions.getAppFolderFromHelper(helperFilePath), controllerName);
        IFile file = helperFile.getProject().getFile(controllerPath);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static String getPluralResourceNameFromHelperPath(String helperFileName) {
        return helperFileName.substring(0, helperFileName.length() - HELPER_FILE_SUFFIX.length());
    }

    private static IPath getAppFolderFromHelper(IPath helperFilePath) {
        return helperFilePath.removeLastSegments(2);
    }

    public static IFile getModelFromHelper(IFile helperFile) {
        if (!RailsConventions.looksLikeHelper(helperFile)) {
            return null;
        }
        IPath helperFilePath = helperFile.getProjectRelativePath();
        String helperFilename = helperFilePath.lastSegment();
        String modelName = String.valueOf(Inflector.singularize(RailsConventions.getPluralResourceNameFromHelperPath(helperFilename))) + RB;
        IPath model = RailsConventions.getModelFromHelper(helperFilePath, modelName);
        IFile file = helperFile.getProject().getFile(model);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static IFile getControllerFromFunctionalTest(IFile currentFile) {
        if (!RailsConventions.looksLikeFunctionalTest(currentFile)) {
            return null;
        }
        IPath helperFilePath = currentFile.getProjectRelativePath();
        String filename = helperFilePath.lastSegment();
        String[] namespace = RailsConventions.getControllerNamespace(helperFilePath);
        IPath railsRoot = RailsPlugin.findRailsRoot(currentFile.getProject());
        String controllerName = String.valueOf(filename.substring(0, filename.length() - UNIT_TEST_SUFFIX.length())) + RB;
        IPath controller = railsRoot.append(APP).append(CONTROLLERS);
        int i = 0;
        while (i < namespace.length) {
            controller = controller.append(namespace[i]);
            ++i;
        }
        controller = controller.append(controllerName);
        IFile file = currentFile.getProject().getFile(controller);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static String[] getControllerNamespace(IPath helperFilePath) {
        String[] segments = helperFilePath.segments();
        ArrayList<String> namespace = new ArrayList<String>();
        int i = segments.length - 2;
        while (i >= 0) {
            if (segments[i].equals(VIEWS)) {
                namespace.remove(0);
                break;
            }
            if (segments[i].equals(FUNCTIONAL) || segments[i].equals(CONTROLLERS)) break;
            namespace.add(segments[i]);
            --i;
        }
        Collections.reverse(namespace);
        return namespace.toArray(new String[namespace.size()]);
    }

    private static boolean looksLikeFunctionalTest(IFile currentFile) {
        IPath railsRoot = RailsPlugin.findRailsRoot(currentFile.getProject());
        if (!railsRoot.isPrefixOf(currentFile.getProjectRelativePath())) {
            return false;
        }
        IPath relativeToRailsRoot = currentFile.getProjectRelativePath().removeFirstSegments(railsRoot.segmentCount());
        if (!relativeToRailsRoot.segment(0).equals(TEST)) {
            return false;
        }
        if (!relativeToRailsRoot.segment(1).equals(FUNCTIONAL)) {
            return false;
        }
        return relativeToRailsRoot.lastSegment().endsWith(UNIT_TEST_SUFFIX);
    }

    public static IFile getControllerFromUnitTest(IFile currentFile) {
        if (!RailsConventions.looksLikeUnitTest(currentFile)) {
            return null;
        }
        String fileName = currentFile.getProjectRelativePath().lastSegment();
        IPath railsRoot = RailsPlugin.findRailsRoot(currentFile.getProject());
        String singularModel = fileName.substring(0, fileName.length() - UNIT_TEST_SUFFIX.length());
        String controllerName = String.valueOf(Inflector.pluralize(singularModel)) + CONTROLLER_FILE_SUFFIX;
        IPath controller = railsRoot.append(APP).append(CONTROLLERS).append(controllerName);
        IFile file = currentFile.getProject().getFile(controller);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static boolean looksLikeUnitTest(IFile currentFile) {
        IPath railsRoot = RailsPlugin.findRailsRoot(currentFile.getProject());
        if (!railsRoot.isPrefixOf(currentFile.getProjectRelativePath())) {
            return false;
        }
        IPath relativeToRailsRoot = currentFile.getProjectRelativePath().removeFirstSegments(railsRoot.segmentCount());
        if (!relativeToRailsRoot.segment(0).equals(TEST)) {
            return false;
        }
        if (!relativeToRailsRoot.segment(1).equals(UNIT)) {
            return false;
        }
        return relativeToRailsRoot.lastSegment().endsWith(UNIT_TEST_SUFFIX);
    }

    public static IFile getModelFromFunctionalTest(IFile currentFile) {
        if (!RailsConventions.looksLikeFunctionalTest(currentFile)) {
            return null;
        }
        IPath filePath = currentFile.getProjectRelativePath();
        String fileName = filePath.lastSegment();
        int i = 0;
        while (i < filePath.segmentCount()) {
            if (filePath.segment(i).equals(FUNCTIONAL)) {
                fileName = filePath.removeFirstSegments(i + 1).toPortableString();
                break;
            }
            ++i;
        }
        String pluralModelName = fileName.substring(0, fileName.length() - FUNCTIONAL_TEST_SUFFIX.length());
        String modelName = String.valueOf(Inflector.singularize(pluralModelName)) + RB;
        IPath model = new Path(APP).append(MODELS).append(modelName);
        IFile file = currentFile.getProject().getFile(model);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static IFile getModelFromUnitTest(IFile currentFile) {
        if (!RailsConventions.looksLikeUnitTest(currentFile)) {
            return null;
        }
        IPath filePath = currentFile.getProjectRelativePath();
        String fileName = filePath.lastSegment();
        String modelName = String.valueOf(fileName.substring(0, fileName.length() - UNIT_TEST_SUFFIX.length())) + RB;
        IPath model = new Path(APP).append(MODELS).append(modelName);
        IFile file = currentFile.getProject().getFile(model);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static IFile getHelperFromFunctionalTest(IFile currentFile) {
        if (!RailsConventions.looksLikeFunctionalTest(currentFile)) {
            return null;
        }
        IPath filePath = currentFile.getProjectRelativePath();
        String fileName = filePath.lastSegment();
        IPath railsRoot = RailsPlugin.findRailsRoot(currentFile.getProject());
        String pluralModelName = fileName.substring(0, fileName.length() - FUNCTIONAL_TEST_SUFFIX.length());
        String helperName = String.valueOf(pluralModelName) + HELPER_FILE_SUFFIX;
        IPath helper = railsRoot.append(APP).append(HELPERS).append(helperName);
        IFile file = currentFile.getProject().getFile(helper);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static IFile getHelperFromUnitTest(IFile currentFile) {
        if (!RailsConventions.looksLikeUnitTest(currentFile)) {
            return null;
        }
        IPath filePath = currentFile.getProjectRelativePath();
        String fileName = filePath.lastSegment();
        String modelName = fileName.substring(0, fileName.length() - UNIT_TEST_SUFFIX.length());
        String helperName = String.valueOf(Inflector.pluralize(modelName)) + HELPER_FILE_SUFFIX;
        IPath helper = new Path(APP).append(HELPERS).append(helperName);
        IFile file = currentFile.getProject().getFile(helper);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static boolean looksLikeModel(IFile currentFile) {
        if (currentFile == null) {
            return false;
        }
        IPath path = currentFile.getProjectRelativePath();
        int index = RailsConventions.findAppIndex(path);
        if (index == -1) {
            return false;
        }
        if (index + 2 > path.segmentCount()) {
            return false;
        }
        String appSubfolder = path.segment(index + 1);
        if (!appSubfolder.equals(MODELS)) {
            return false;
        }
        String modelFilename = path.lastSegment();
        return modelFilename.endsWith(RB);
    }

    public static boolean looksLikeTest(IFile currentFile) {
        if (currentFile == null) {
            return false;
        }
        IPath path = currentFile.getProjectRelativePath();
        int index = RailsConventions.findTestIndex(path);
        if (index == -1) {
            return false;
        }
        if (index + 2 > path.segmentCount()) {
            return false;
        }
        String appSubfolder = path.segment(index + 1);
        if (appSubfolder.equals(UNIT)) {
            return path.lastSegment().endsWith(UNIT_TEST_SUFFIX);
        }
        if (appSubfolder.equals(FUNCTIONAL)) {
            return path.lastSegment().endsWith(FUNCTIONAL_TEST_SUFFIX);
        }
        return false;
    }

    private static int findAppIndex(IPath path) {
        return RailsConventions.findSegmentIndex(path, APP);
    }

    private static int findTestIndex(IPath path) {
        return RailsConventions.findSegmentIndex(path, TEST);
    }

    private static int findSegmentIndex(IPath path, String segmentToFind) {
        int i = 0;
        while (i < path.segmentCount()) {
            String segment = path.segment(i);
            if (segment.equals(segmentToFind)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

