/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.radrails.rails.core.RailsLog;
import org.radrails.server.core.Server;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ServerManagerContentHandler
implements ContentHandler {
    private StringBuffer data;
    private Collection<Server> servers;
    private String environment;
    private String port;
    private String name;
    private String host;
    private IProject project;
    private String type;

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.servers = new ArrayList<Server>();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = start;
        while (i < start + length) {
            this.data.append(ch[i]);
            ++i;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("project")) {
            this.project = this.findProject(this.data.toString());
        } else if (qName.equals("name")) {
            this.name = this.data.toString();
        } else if (qName.equals("port")) {
            this.port = this.data.toString();
        } else if (qName.equals("environment")) {
            this.environment = this.data.toString();
        } else if (qName.equals("host")) {
            this.host = this.data.toString();
        } else if (qName.equals("server")) {
            if (this.project != null) {
                this.servers.add(new Server(this.project, this.name, this.type, this.host, this.port, this.environment));
            }
            this.host = null;
        }
    }

    private IProject findProject(String string) {
        IPath proj = Path.fromPortableString((String)string);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IPath projFile = projects[i].getLocation();
            if (projFile.equals((Object)proj)) {
                return projects[i];
            }
            ++i;
        }
        RailsLog.logError((String)("Unable to find a project for saved Rails server. Project path: " + string), (Throwable)new IllegalStateException());
        return null;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.data = new StringBuffer();
        if (qName.equals("server")) {
            this.type = atts.getValue("type");
        }
    }

    public Collection getServers() {
        return this.servers;
    }
}

