/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclipsemonkey.lang.ruby;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.eclipsemonkey.DOMDescriptor;
import org.eclipse.eclipsemonkey.IMonkeyScriptRunner;
import org.eclipse.eclipsemonkey.ScriptMetadata;
import org.eclipse.eclipsemonkey.Subscription;
import org.eclipse.eclipsemonkey.lang.ruby.RubyScriptRunner;
import org.eclipse.eclipsemonkey.language.IMonkeyLanguageFactory;
import org.eclipse.ui.IWorkbenchWindow;

public class RubyLanguageFactory
implements IMonkeyLanguageFactory {
    public IMonkeyScriptRunner getRunMonkeyScript(IPath path, IWorkbenchWindow window) {
        return new RubyScriptRunner(path, window);
    }

    public void init(String pluginID, String languageName) {
    }

    public ScriptMetadata getScriptMetadata(String contents) {
        ScriptMetadata metadata = new ScriptMetadata();
        Pattern p = Pattern.compile("^=begin.*?=end", 32);
        Matcher m = p.matcher(contents);
        if (m.find()) {
            String comment = m.group();
            p = Pattern.compile("Menu:\\s*((\\p{Graph}| )+)", 32);
            m = p.matcher(comment);
            if (m.find()) {
                metadata.setMenuName(m.group(1));
            }
            if ((m = (p = Pattern.compile("OnLoad:\\s*((\\p{Graph}| )+)", 32)).matcher(comment)).find()) {
                String funct = m.group(1);
                if (funct.endsWith("()")) {
                    // empty if block
                }
                funct = funct.substring(0, funct.length() - 2);
                metadata.setOnLoadFunction(funct);
            }
            if ((m = (p = Pattern.compile("Key:\\s*((\\p{Graph}| )+)", 32)).matcher(comment)).find()) {
                metadata.setKey(m.group(1));
            }
            if ((m = (p = Pattern.compile("Scope:\\s*((\\p{Graph}| )+)", 32)).matcher(comment)).find()) {
                metadata.setScopeName(m.group(1));
            }
            p = Pattern.compile("DOM:\\s*(\\p{Graph}+)\\/((\\p{Alnum}|\\.)+)", 32);
            m = p.matcher(comment);
            while (m.find()) {
                metadata.getDOMs().add(new DOMDescriptor(m.group(1), m.group(2)));
            }
            p = Pattern.compile("Listener:\\s*(\\w+)\\(\\)\\.(\\w+)", 32);
            m = p.matcher(comment);
            while (m.find()) {
                metadata.getSubscriptions().add(new Subscription(m.group(1), m.group(2)));
            }
        }
        return metadata;
    }
}

