/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb.wizards;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.erb.ERBPlugin;
import com.aptana.ide.editor.erb.wizards.Messages;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.wizards.SimpleNewFileWizard;
import com.aptana.ide.editors.wizards.SimpleNewWizardPage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Version;
import org.radrails.rails.internal.core.RailsPlugin;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.RubyCore;

public class ERBNewFileWizard
extends SimpleNewFileWizard
implements INewWizard {
    private static final String HTML_ERB = ".html.erb";
    private static final String RHTML = ".rhtml";

    public ERBNewFileWizard() {
        this.setWindowTitle(Messages.ERBNewFileWizard_Window_Title);
    }

    protected SimpleNewWizardPage createNewFilePage(ISelection selection) {
        SimpleNewWizardPage page = new SimpleNewWizardPage(selection);
        page.setRequiredFileExtensions(new String[]{"erb", "rhtml"});
        page.setTitle(Messages.ERBNewFileWizard_Filename);
        page.setDescription(Messages.ERBNewFileWizard_Description);
        IPreferenceStore store = ERBPlugin.getDefault().getPreferenceStore();
        String filename = store.getString("com.aptana.ide.editor.erb.ERBEDITOR_INITIAL_FILE_NAME");
        String extension = this.getProperExtension(selection);
        if (extension != null) {
            Path path = new Path(filename);
            String oldExtension = path.getFileExtension();
            int toRemove = 0;
            if (oldExtension != null) {
                toRemove = oldExtension.length() + 1;
            }
            filename = String.valueOf(filename.substring(0, filename.length() - toRemove)) + extension;
        }
        page.setDefaultFileName(filename);
        return page;
    }

    private String getProperExtension(ISelection selection) {
        String extension = null;
        if (selection instanceof IStructuredSelection) {
            IAdaptable adaptable;
            Object resource;
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object first = structured.getFirstElement();
            if (!(first instanceof IResource) && first instanceof IAdaptable && (resource = (adaptable = (IAdaptable)first).getAdapter(IResource.class)) != null) {
                first = resource;
            }
            if (first instanceof IResource) {
                IResource res = (IResource)first;
                IProject proj = res.getProject();
                String version = RailsPlugin.getRailsVersion((IProject)proj);
                if (version == null) {
                    return HTML_ERB;
                }
                Version yeah = new Version(version);
                extension = yeah.getMajor() >= 2 ? HTML_ERB : RHTML;
            }
        }
        return extension;
    }

    protected String getInitialFileContents() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        IPreferenceStore store = ERBPlugin.getDefault().getPreferenceStore();
        String contents = store.getString("com.aptana.ide.editor.erb.ERBEDITOR_INITIAL_CONTENTS");
        pw.println(contents);
        pw.close();
        return sw.toString();
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(com.aptana.ide.editors.wizards.Messages.SimpleNewFileWizard_Creating) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(StringUtils.format((String)com.aptana.ide.editors.wizards.Messages.SimpleNewFileWizard_ContainerDoesNotExist, (String)containerName));
        }
        IContainer container = (IContainer)resource;
        Path filePath = new Path(fileName);
        final IFile file = container.getFile((IPath)filePath);
        IRubyElement rubyContainer = RubyCore.create((IResource)resource);
        String source = this.getInitialFileContents();
        if (rubyContainer instanceof ISourceFolder) {
            ISourceFolder folder = (ISourceFolder)rubyContainer;
            folder.createRubyScript(filePath.lastSegment(), source, true, monitor);
        }
        monitor.worked(1);
        monitor.setTaskName(com.aptana.ide.editors.wizards.Messages.SimpleNewFileWizard_OpeningFileForEditing);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    if (part instanceof IUnifiedEditor) {
                        IUnifiedEditor te = (IUnifiedEditor)part;
                        te.getViewer().getTextWidget().setCaretOffset(ERBNewFileWizard.this.getInitialCaretOffset());
                    }
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    public boolean performFinish() {
        SimpleNewWizardPage page = (SimpleNewWizardPage)this.getPages()[0];
        final String containerName = page.getContainerName();
        final String fileName = page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ERBNewFileWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)com.aptana.ide.editors.wizards.Messages.SimpleNewFileWizard_Error, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.aptana.ide.core.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }
}

