/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb;

import com.aptana.ide.editor.erb.ERBPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.RailsUIPlugin;

public class ExpressionCloser
implements VerifyKeyListener,
IPropertyChangeListener {
    private static final char SINGLE_QUOTE_STRING = '\'';
    private static final char DOUBLE_QUOTE_STRING = '\"';
    private static final String COMMENT_HASH = "#";
    private SourceViewer fSourceViewer;
    private boolean fEnabled;

    public ExpressionCloser(SourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
        this.fEnabled = ERBPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.erb.ERBEDITOR_AUTO_CLOSE");
        RailsUIPlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.aptana.ide.editor.erb.ERBEDITOR_AUTO_CLOSE")) {
            this.fEnabled = (Boolean)event.getNewValue();
        }
    }

    protected void moveCursor(int cursorDelta) {
        int widgetCursorPos = this.fSourceViewer.getTextWidget().getCaretOffset();
        int docCursorPos = this.fSourceViewer.widgetOffset2ModelOffset(widgetCursorPos);
        this.fSourceViewer.setSelectedRange(docCursorPos + cursorDelta, 0);
    }

    protected boolean isCurrentLineRubyComment() {
        try {
            IDocument document = this.fSourceViewer.getDocument();
            Point selection = this.fSourceViewer.getSelectedRange();
            int cursorOffset = selection.x;
            int lineNumber = document.getLineOfOffset(cursorOffset);
            int lineLength = document.getLineLength(lineNumber);
            int lineOffset = document.getLineOffset(lineNumber);
            String lineText = document.get(lineOffset, lineLength);
            if (lineText.trim().startsWith(COMMENT_HASH)) {
                return true;
            }
        }
        catch (BadLocationException e) {
            RailsUILog.logError((String)"Bad location", (Throwable)e);
        }
        return false;
    }

    protected boolean isCursorInsideString() {
        return this.isCursorInsideString('\"') || this.isCursorInsideString('\'');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isCursorInsideString(char stringDelimiter) {
        try {
            IDocument document = this.fSourceViewer.getDocument();
            Point selection = this.fSourceViewer.getSelectedRange();
            int cursorOffset = selection.x;
            int lineNumber = document.getLineOfOffset(cursorOffset);
            int lineLength = document.getLineLength(lineNumber);
            int lineOffset = document.getLineOffset(lineNumber);
            int cursorPos = cursorOffset - lineOffset;
            String lineText = document.get(lineOffset, lineLength);
            boolean loop = false;
            int searchPos = 0;
            do {
                int openQuotePos = lineText.indexOf(stringDelimiter, searchPos);
                int closeQuotePos = lineText.indexOf(stringDelimiter, openQuotePos + 1);
                if (openQuotePos <= -1 || closeQuotePos <= -1) continue;
                if (cursorPos > openQuotePos && cursorPos <= closeQuotePos) {
                    return true;
                }
                searchPos = closeQuotePos + 1;
                return false;
            } while (loop = false);
            return false;
        }
        catch (BadLocationException e) {
            RailsUILog.logError((String)"Bad location", (Throwable)e);
        }
        return false;
    }

    public void verifyKey(VerifyEvent event) {
        if (!this.fEnabled) {
            return;
        }
        if (this.isCurrentLineRubyComment()) {
            return;
        }
        if (this.isCursorInsideString()) {
            return;
        }
        IDocument document = this.fSourceViewer.getDocument();
        Point selection = this.fSourceViewer.getSelectedRange();
        int cursorOffset = selection.x;
        int selectionLength = selection.y;
        if (event.character == '%') {
            try {
                char prevChar = document.getChar(cursorOffset - 1);
                if (prevChar == '<') {
                    StringBuffer sb = new StringBuffer();
                    sb.append(event.character);
                    sb.append('%');
                    sb.append('>');
                    document.replace(cursorOffset, selectionLength, sb.toString());
                    event.doit = false;
                    this.moveCursor(1);
                }
            }
            catch (BadLocationException e) {
                RailsUILog.logError((String)"Bad location", (Throwable)e);
            }
        }
    }
}

