/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb;

import com.aptana.ide.editor.erb.parsing.ExtendedHTMLParser;
import com.aptana.ide.editor.html.HTMLFileServiceFactory;
import com.aptana.ide.editors.unified.BaseFileLanguageService;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.ParserInitializationException;

public class ERBFileServiceFactory
extends HTMLFileServiceFactory {
    private static final String LANGUAGE = "text/html+rb";
    private static HTMLFileServiceFactory instance;

    protected void createChildFileServices(IParser parser, FileService fileService, IParseState parseState, ParentOffsetMapper mapper) {
        super.createChildFileServices(parser, fileService, parseState, mapper);
        IParser erbParser = parser.getParserForMimeType("text/ruby");
        BaseFileLanguageService phpService = new BaseFileLanguageService(fileService, parseState, erbParser, (IParentOffsetMapper)mapper);
        fileService.addLanguageService("text/ruby", (IFileLanguageService)phpService);
    }

    protected IParser createParser() {
        Object result = null;
        try {
            if (LanguageRegistry.hasParser((String)LANGUAGE)) {
                result = LanguageRegistry.getParser((String)LANGUAGE);
            } else {
                result = new ExtendedHTMLParser();
                LanguageRegistry.registerParser((String)LANGUAGE, (IParser)result);
            }
        }
        catch (ParserInitializationException parserInitializationException) {}
        return result;
    }

    public static HTMLFileServiceFactory getInstance() {
        if (instance == null) {
            instance = new ERBFileServiceFactory();
        }
        return instance;
    }
}

