/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.util;

import java.util.regex.Pattern;
import org.jruby.lexer.yacc.RubyYaccLexer;

public class NameValidator {
    private static final String localVariableRegexp = "[a-z_]\\w*";
    private static final String methodNameRegexp = "[a-zA-Z_]\\w*[!?=]?";
    private static final String classNameRegexp = "[A-Z_]\\w*";

    public static boolean isValidLocalVariableName(String name) {
        return NameValidator.validate(localVariableRegexp, name);
    }

    public static boolean isValidMethodName(String name) {
        return NameValidator.validate(methodNameRegexp, name);
    }

    public static boolean isValidConstName(String name) {
        return NameValidator.validate(classNameRegexp, name);
    }

    private static boolean validate(String regexp, String stringToValidate) {
        boolean valid = Pattern.compile(regexp).matcher(stringToValidate).matches();
        return valid && RubyYaccLexer.getKeyword((String)stringToValidate) == null;
    }

    public static boolean isValidConstantName(String newName) {
        return NameValidator.isValidConstName(newName);
    }
}

