/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameHelper {
    public static String createName(String string) {
        Matcher matcher = Pattern.compile("([@]{0,2}\\w*[a-zA-Z_])(\\d+)").matcher(string);
        if (matcher.matches()) {
            return String.valueOf(matcher.group(1)) + String.valueOf(Integer.valueOf(matcher.group(2)) + 1);
        }
        return String.valueOf(string) + 1;
    }

    public static ArrayList<String> findDuplicates(String[] myNames, String[] oldNames) {
        ArrayList<String> found = new ArrayList<String>();
        int i = 0;
        while (i < oldNames.length) {
            if (NameHelper.namesContainName(myNames, oldNames[i])) {
                found.add(oldNames[i]);
            }
            ++i;
        }
        return found;
    }

    public static boolean namesContainName(String[] names, String name) {
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean fieldnameExistsInClass(String name, ClassNodeWrapper klass) {
        for (FieldNodeWrapper currentTargetField : klass.getFields()) {
            if (!name.equals(currentTargetField.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean methodnameExistsInClassPart(String methodName, ClassNodeWrapper klass) {
        return NameHelper.methodsContainMethod(klass.getMethods(), methodName);
    }

    private static boolean methodsContainMethod(Collection<MethodNodeWrapper> methods, String methodName) {
        for (MethodNodeWrapper currentTargetMethod : methods) {
            if (!methodName.equals(currentTargetMethod.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean fieldsContainField(Collection<FieldNodeWrapper> fields, String fieldName) {
        for (FieldNodeWrapper currentField : fields) {
            if (!fieldName.equals(currentField.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean methodnameExistsInClass(String methodName, ClassNodeWrapper classNode) {
        return NameHelper.methodsContainMethod(classNode.getMethods(), methodName);
    }

    public static String createMethodName(MethodNodeWrapper methodWrapper, ClassNodeWrapper klass) {
        String newName = methodWrapper.getName();
        while (NameHelper.methodsContainMethod(klass.getMethods(), newName)) {
            newName = NameHelper.createName(newName);
        }
        return newName;
    }

    public static String createFieldName(FieldNodeWrapper fieldWrapper, ClassNodeWrapper klass) {
        String newName = fieldWrapper.getName();
        while (NameHelper.fieldsContainField(klass.getFields(), newName)) {
            newName = NameHelper.createName(newName);
        }
        return newName;
    }

    public static String getEncosingModulePrefix(Node rootNode, Node node) {
        Node parent;
        Vector<String> nameParts = new Vector<String>();
        while ((parent = NodeProvider.findParentNode(rootNode, node, ModuleNode.class)) != null) {
            Colon3Node path = ((ModuleNode)parent).getCPath();
            if (path != node) {
                nameParts.insertElementAt(NameHelper.getFullyQualifiedName((Node)path), 0);
            }
            node = parent;
        }
        StringBuilder prefix = new StringBuilder();
        Iterator it = nameParts.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            prefix.append(name);
            if (!it.hasNext()) continue;
            prefix.append("::");
        }
        return prefix.toString();
    }

    public static String getFullyQualifiedName(Node n) {
        assert (n instanceof ConstNode || n instanceof Colon2Node);
        if (n instanceof ConstNode) {
            ConstNode constNode = (ConstNode)n;
            return constNode.getName();
        }
        StringBuilder name = new StringBuilder();
        ArrayList<Node> subNodes = new ArrayList<Node>(NodeProvider.getSubNodes(((Colon2Node)n).getLeftNode(), Colon2Node.class, ConstNode.class));
        Collections.reverse(subNodes);
        for (Node node : subNodes) {
            name.append(((INameNode)node).getName());
            name.append("::");
        }
        name.append(((INameNode)n).getName());
        return name.toString();
    }
}

