/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.util;

import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;

public abstract class JRubyRefactoringUtils {
    public static boolean isParameter(LocalNodeWrapper selectedItem, MethodDefNode enclosingMethod) {
        return JRubyRefactoringUtils.isParameter(enclosingMethod.getScope().getVariables()[selectedItem.getId()], enclosingMethod);
    }

    public static boolean isParameter(String name, MethodDefNode enclosingMethod) {
        ArgsNode argsNode = enclosingMethod.getArgsNode();
        ListNode argumentList = argsNode.getArgs();
        if (argumentList == null) {
            return false;
        }
        for (Object currentArg : argumentList.childNodes()) {
            ArgumentNode arg;
            if (!(currentArg instanceof ArgumentNode) || !(arg = (ArgumentNode)currentArg).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMathematicalExpression(Node node) {
        String[] operators;
        if (!(node instanceof CallNode)) {
            return false;
        }
        String name = ((CallNode)node).getName();
        String[] stringArray = operators = new String[]{"**", "!", "+", "-", "*", "/", "%", ">>", "<<", "&", "^", "|", "+@", "-@", "<=>", ">", "<", ">=", "<=", "==", "===", "~", "&&"};
        int n = operators.length;
        int n2 = 0;
        while (n2 < n) {
            String currentOp = stringArray[n2];
            if (name.equals(currentOp)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasSamePosition(Node node1, Node node2) {
        int end2;
        int start2;
        String file2;
        String file1 = node1.getPosition().getFile();
        if (!file1.equals(file2 = node2.getPosition().getFile())) {
            return false;
        }
        int start1 = node1.getPosition().getStartOffset();
        if (start1 != (start2 = node2.getPosition().getStartOffset())) {
            return false;
        }
        int end1 = node1.getPosition().getEndOffset();
        return end1 == (end2 = node2.getPosition().getEndOffset());
    }
}

