/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.util;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class FileHelper {
    public static final String DEFAULT_LINE_DELIMITER = System.getProperty("line.separator");

    public static String getFileContent(String fileName) {
        try {
            return FileHelper.getReaderContent(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getReaderContent(Reader reader) {
        try {
            int character;
            StringBuilder contentBuilder = new StringBuilder();
            while ((character = reader.read()) != -1) {
                contentBuilder.append((char)character);
            }
            return contentBuilder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getLineDelimiter(String document) {
        int i = 0;
        while (i < document.length()) {
            char currentChar = document.charAt(i);
            if (currentChar == '\r') {
                if (document.length() > i + 1 && document.charAt(i + 1) == '\n') {
                    return "\r\n";
                }
                return "\r";
            }
            if (currentChar == '\n') {
                return "\n";
            }
            ++i;
        }
        return DEFAULT_LINE_DELIMITER;
    }
}

