/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages.extractmethod;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.rubypeople.rdt.refactoring.ui.LabeledTextField;
import org.rubypeople.rdt.refactoring.ui.RdtCodeViewer;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.IValidationController;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.ParametersTableCellEditorListener;

public class ExtractMethodComposite
extends Composite {
    private Group accessModifierGroup;
    private Composite modifySelectionEditorComposite;
    private Label modifySelectionLabel;
    private Button privateAccessRadioButton;
    private Button protectedAccessRadioButton;
    private Button publicAccessRadioButton;
    private Label methodSignaturePreviewLabel;
    private Label methodSignatureLabel;
    private Button replaceAllCheckbox;
    private Label parametersLabel;
    private Button editParametersButton;
    private TableColumn parametersTableNameColumns;
    private Table parametersTable;
    private Button downParametersButton;
    private Button upParametersButton;
    private LabeledTextField newMethodName;
    private RdtCodeViewer selectionPreview;
    private final IValidationController validationController;
    private ParametersTableCellEditorListener cellEditorListener;
    private Button noneAccessRadioButton;

    public ExtractMethodComposite(Composite parent, IValidationController validationController, boolean hasParameters, boolean needsAccessModifiers) {
        super(parent, 0);
        this.validationController = validationController;
        this.setLayout((Layout)new GridLayout());
        this.createNewMethodNameComposite(this);
        if (needsAccessModifiers) {
            this.createAccessModifierComposite(this);
        }
        if (hasParameters) {
            this.createParametersComposite(this);
        }
        this.createMethodSignatureComposite(this);
        this.createModifySelectionComposite(this);
        this.layout();
    }

    public LabeledTextField getNewMethodNameText() {
        return this.newMethodName;
    }

    private void createModifySelectionComposite(Composite control) {
        Composite modifySelectionComposite = new Composite(control, 0x800000);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.makeColumnsEqualWidth = true;
        GridData compositeLData = new GridData();
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessHorizontalSpace = true;
        compositeLData.grabExcessVerticalSpace = true;
        compositeLData.verticalAlignment = 4;
        modifySelectionComposite.setLayoutData((Object)compositeLData);
        modifySelectionComposite.setLayout((Layout)compositeLayout);
        this.modifySelectionLabel = new Label(modifySelectionComposite, 0);
        GridData labelLData = new GridData();
        labelLData.verticalAlignment = 1;
        this.modifySelectionLabel.setLayoutData((Object)labelLData);
        this.modifySelectionLabel.setText(Messages.ExtractMethodComposite_SelectedCode);
        this.modifySelectionEditorComposite = new Composite(modifySelectionComposite, 0);
        FormLayout composite8Layout = new FormLayout();
        GridData composite8LData = new GridData();
        composite8LData.horizontalAlignment = 4;
        composite8LData.grabExcessHorizontalSpace = true;
        composite8LData.grabExcessVerticalSpace = true;
        composite8LData.verticalAlignment = 4;
        this.modifySelectionEditorComposite.setLayoutData((Object)composite8LData);
        this.modifySelectionEditorComposite.setLayout((Layout)composite8Layout);
        this.selectionPreview = RdtCodeViewer.create(this.modifySelectionEditorComposite);
        FormData textLData = new FormData(0, 0);
        textLData.right = new FormAttachment(1000, 1000, 0);
        textLData.left = new FormAttachment(0, 1000, 0);
        textLData.top = new FormAttachment(0, 1000, 0);
        textLData.bottom = new FormAttachment(1000, 1000, 0);
        this.selectionPreview.getTextWidget().setLayoutData((Object)textLData);
        Composite modifySelectionButtonComposite = new Composite(this.modifySelectionEditorComposite, 0);
        GridLayout composite9Layout = new GridLayout();
        composite9Layout.makeColumnsEqualWidth = true;
        composite9Layout.marginHeight = 0;
        FormData composite9LData = new FormData();
        composite9LData.width = 80;
        composite9LData.right = new FormAttachment(1000, 1000, 0);
        composite9LData.top = new FormAttachment(0, 1000, 0);
        composite9LData.bottom = new FormAttachment(1005, 1000, 0);
        modifySelectionButtonComposite.setLayoutData((Object)composite9LData);
        modifySelectionButtonComposite.setLayout((Layout)composite9Layout);
        Label selectionHelpLabel = new Label(modifySelectionComposite, 0);
        GridData labelData = new GridData();
        labelData.verticalAlignment = 1;
        selectionHelpLabel.setLayoutData((Object)labelData);
        FontData fontData = selectionHelpLabel.getFont().getFontData()[0];
        Font font = new Font(this.getFont().getDevice(), fontData.getName(), fontData.getHeight(), fontData.getStyle() | 2);
        selectionHelpLabel.setFont(font);
        selectionHelpLabel.setText(Messages.ExtractMethodComposite_ExpansionHint);
    }

    private Button createButton(Composite parent, String name) {
        Button button = new Button(parent, 0x1000008);
        GridData buttonLData = new GridData();
        buttonLData.horizontalAlignment = 4;
        buttonLData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)buttonLData);
        button.setText(name);
        return button;
    }

    private void createMethodSignatureComposite(Composite control) {
        Composite methodSignatureComposite = new Composite(control, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.makeColumnsEqualWidth = true;
        GridData compositeLData = new GridData();
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessHorizontalSpace = true;
        methodSignatureComposite.setLayoutData((Object)compositeLData);
        methodSignatureComposite.setLayout((Layout)compositeLayout);
        this.methodSignatureLabel = new Label(methodSignatureComposite, 0);
        GridData labelLData = new GridData();
        labelLData.horizontalAlignment = 4;
        labelLData.grabExcessHorizontalSpace = true;
        this.methodSignatureLabel.setLayoutData((Object)labelLData);
        this.methodSignatureLabel.setText(Messages.ExtractMethodComposite_SignaturePreview);
        this.methodSignaturePreviewLabel = new Label(methodSignatureComposite, 0);
        GridData methodSignaturePreviewData = new GridData();
        methodSignaturePreviewData.horizontalAlignment = 4;
        methodSignaturePreviewData.grabExcessHorizontalSpace = true;
        methodSignaturePreviewData.verticalAlignment = 4;
        methodSignaturePreviewData.grabExcessVerticalSpace = true;
        this.methodSignaturePreviewLabel.setLayoutData((Object)methodSignaturePreviewData);
        this.methodSignaturePreviewLabel.setText("def");
    }

    private void createParametersComposite(Composite control) {
        Composite parametersComposite = new Composite(control, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.makeColumnsEqualWidth = true;
        GridData compositeLData = new GridData();
        compositeLData.grabExcessHorizontalSpace = true;
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessVerticalSpace = true;
        compositeLData.verticalAlignment = 4;
        parametersComposite.setLayoutData((Object)compositeLData);
        parametersComposite.setLayout((Layout)compositeLayout);
        this.createParametersLabel(parametersComposite);
        this.createParametersTable(parametersComposite);
        this.replaceAllCheckbox = new Button(parametersComposite, 16416);
        GridData buttonLData = new GridData();
        buttonLData.grabExcessHorizontalSpace = true;
        buttonLData.horizontalAlignment = 4;
        this.replaceAllCheckbox.setLayoutData((Object)buttonLData);
        this.replaceAllCheckbox.setText(Messages.ExtractMethodComposite_ReplaceAll);
        this.replaceAllCheckbox.setEnabled(false);
    }

    private void createParametersButton(Composite parametersTableComposite) {
        Composite parametersButtonComposite = new Composite(parametersTableComposite, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.makeColumnsEqualWidth = true;
        FormData compositeLData = new FormData(0, 0);
        compositeLData.width = 80;
        compositeLData.bottom = new FormAttachment(1000, 1000, 0);
        compositeLData.right = new FormAttachment(1000, 1000, 0);
        compositeLData.top = new FormAttachment(0, 1000, 0);
        parametersButtonComposite.setLayoutData((Object)compositeLData);
        parametersButtonComposite.setLayout((Layout)compositeLayout);
        this.editParametersButton = this.createButton(parametersButtonComposite, Messages.ExtractMethodComposite_ButtonEdit);
        this.editParametersButton.setEnabled(false);
        this.upParametersButton = this.createButton(parametersButtonComposite, Messages.ExtractMethodComposite_ButtonUp);
        this.upParametersButton.setEnabled(false);
        this.downParametersButton = this.createButton(parametersButtonComposite, Messages.ExtractMethodComposite_ButtonDown);
        this.downParametersButton.setEnabled(false);
    }

    private Composite createParametersTable(Composite parametersComposite) {
        Composite parametersTableComposite = new Composite(parametersComposite, 0);
        FormLayout compositeLayout = new FormLayout();
        GridData compositeLData = new GridData();
        compositeLData.grabExcessHorizontalSpace = true;
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessVerticalSpace = true;
        compositeLData.verticalAlignment = 4;
        parametersTableComposite.setLayoutData((Object)compositeLData);
        parametersTableComposite.setLayout((Layout)compositeLayout);
        this.parametersTable = new Table(parametersTableComposite, 2048);
        FormData tableLData = new FormData();
        tableLData.bottom = new FormAttachment(1000, 1000, 0);
        tableLData.left = new FormAttachment(0, 1000, 0);
        tableLData.right = new FormAttachment(1000, 1000, -80);
        tableLData.top = new FormAttachment(0, 1000, 4);
        this.parametersTable.setLayoutData((Object)tableLData);
        this.parametersTable.setHeaderVisible(true);
        this.parametersTableNameColumns = new TableColumn(this.parametersTable, 0);
        this.parametersTableNameColumns.setText(Messages.ExtractMethodComposite_Name);
        this.parametersTableNameColumns.setWidth(60);
        this.createParametersButton(parametersTableComposite);
        this.cellEditorListener = new ParametersTableCellEditorListener(this.parametersTable, this.validationController);
        this.parametersTable.addListener(8, (Listener)this.cellEditorListener);
        this.editParametersButton.addListener(13, (Listener)this.cellEditorListener);
        return parametersTableComposite;
    }

    private void createParametersLabel(Composite parametersComposite) {
        this.parametersLabel = new Label(parametersComposite, 0);
        GridData labelLData = new GridData();
        labelLData.grabExcessHorizontalSpace = true;
        labelLData.horizontalAlignment = 4;
        this.parametersLabel.setLayoutData((Object)labelLData);
        this.parametersLabel.setText(Messages.ExtractMethodComposite_Parameters);
    }

    private void createAccessModifierComposite(Composite control) {
        Composite accessModifierComposite = new Composite(control, 0);
        FillLayout compositeLayout = new FillLayout(256);
        GridData compositeLData = new GridData();
        compositeLData.grabExcessHorizontalSpace = true;
        compositeLData.horizontalAlignment = 4;
        accessModifierComposite.setLayoutData((Object)compositeLData);
        accessModifierComposite.setLayout((Layout)compositeLayout);
        this.accessModifierGroup = new Group(accessModifierComposite, 32);
        RowLayout groupLayout = new RowLayout(256);
        groupLayout.fill = true;
        this.accessModifierGroup.setLayout((Layout)groupLayout);
        this.accessModifierGroup.setText(Messages.ExtractMethodComposite_AccessModifier);
        this.publicAccessRadioButton = new Button((Composite)this.accessModifierGroup, 16400);
        this.publicAccessRadioButton.setText("public");
        this.protectedAccessRadioButton = new Button((Composite)this.accessModifierGroup, 16400);
        this.protectedAccessRadioButton.setText("protected");
        this.privateAccessRadioButton = new Button((Composite)this.accessModifierGroup, 16400);
        this.privateAccessRadioButton.setText("private");
        this.noneAccessRadioButton = new Button((Composite)this.accessModifierGroup, 16400);
        this.noneAccessRadioButton.setText(Messages.ExtractMethodComposite_SameAsSource);
    }

    private void createNewMethodNameComposite(Composite control) {
        Composite methodNameComposite = new Composite(control, 0);
        FillLayout compositeLayout = new FillLayout(256);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        methodNameComposite.setLayoutData((Object)gridData);
        methodNameComposite.setLayout((Layout)compositeLayout);
        this.newMethodName = new LabeledTextField(methodNameComposite, Messages.ExtractMethodComposite_MethodName);
    }

    public RdtCodeViewer getCodeViewer() {
        return this.selectionPreview;
    }

    public Table getParametersTable() {
        return this.parametersTable;
    }

    public Button getDownParametersButton() {
        return this.downParametersButton;
    }

    public Button getEditParametersButton() {
        return this.editParametersButton;
    }

    public Button getUpParametersButton() {
        return this.upParametersButton;
    }

    public ParametersTableCellEditorListener getCellEditorListener() {
        return this.cellEditorListener;
    }

    public Button getPrivateAccessRadioButton() {
        return this.privateAccessRadioButton;
    }

    public Button getProtectedAccessRadioButton() {
        return this.protectedAccessRadioButton;
    }

    public Button getPublicAccessRadioButton() {
        return this.publicAccessRadioButton;
    }

    public Label getMethodSignaturePreviewLabel() {
        return this.methodSignaturePreviewLabel;
    }

    public Button getNoneAccessRadioButton() {
        return this.noneAccessRadioButton;
    }
}

