/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages.extractmethod;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.MethodArgumentTableItem;

public class ButtonStateListener
implements Observer,
Listener {
    private final Table table;
    private final Button upButton;
    private final Button downButton;
    private final Button editButton;

    public ButtonStateListener(Table table, Button upButton, Button downButton, Button editButton) {
        this.table = table;
        this.upButton = upButton;
        this.downButton = downButton;
        this.editButton = editButton;
    }

    public void handleEvent(Event event) {
        this.setButtonStates();
    }

    private void setButtonStates() {
        TableItem[] tableItems = this.table.getSelection();
        if (tableItems == null || tableItems.length < 1) {
            this.editButton.setEnabled(false);
            return;
        }
        MethodArgumentTableItem item = (MethodArgumentTableItem)tableItems[0];
        this.upButton.setEnabled(true);
        this.downButton.setEnabled(true);
        this.editButton.setEnabled(true);
        if (item.isMoveable()) {
            MethodArgumentTableItem next;
            if (this.table.getSelectionIndex() == 0) {
                this.upButton.setEnabled(false);
            }
            if (this.table.getSelectionIndex() + 1 == this.table.getItemCount()) {
                this.downButton.setEnabled(false);
            }
            if ((next = this.getNextItem(this.table.getSelectionIndex())) != null && !next.isMoveable()) {
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private MethodArgumentTableItem getNextItem(int selected) {
        if (selected + 1 >= this.table.getItemCount()) {
            return null;
        }
        return (MethodArgumentTableItem)this.table.getItem(selected + 1);
    }

    public void update(Observable arg0, Object arg1) {
        this.setButtonStates();
    }
}

