/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages.encapsulatefield;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.pages.encapsulatefield.IVisibilitySelectionListener;
import org.rubypeople.rdt.refactoring.ui.pages.encapsulatefield.Messages;

public class EncapsulateFieldAccessorComposite
extends Group {
    private Button enableDisableCheckBox;
    private IVisibilitySelectionListener visibilitySelectionListener;
    private VisibilityNodeWrapper.METHOD_VISIBILITY selectedVisibility;
    private Button publicButton;
    private Button protectedButton;
    private Button privateButton;

    public EncapsulateFieldAccessorComposite(Composite parent, String name, VisibilityNodeWrapper.METHOD_VISIBILITY selectedVisibility, boolean isOptional) {
        super(parent, 0);
        this.selectedVisibility = selectedVisibility;
        this.setLayoutData(this.getDefaultGridData());
        this.setLayout((Layout)new GridLayout(1, true));
        this.setText(name);
        if (isOptional) {
            this.initEnableDisableCheckBox(name);
        }
        this.initAccessModifierGroup();
    }

    private void initAccessModifierGroup() {
        Group accessModifierGroup = new Group((Composite)this, 32);
        RowLayout groupLayout = new RowLayout(256);
        groupLayout.fill = true;
        accessModifierGroup.setLayout((Layout)groupLayout);
        accessModifierGroup.setLayoutData((Object)this.getDefaultGridData());
        accessModifierGroup.setText(Messages.EncapsulateFieldAccessorComposite_AccessModifier);
        this.publicButton = this.initAccessModifierButton(accessModifierGroup, "public", VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC);
        this.protectedButton = this.initAccessModifierButton(accessModifierGroup, "protected", VisibilityNodeWrapper.METHOD_VISIBILITY.PROTECTED);
        this.privateButton = this.initAccessModifierButton(accessModifierGroup, "private", VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE);
    }

    private GridData getDefaultGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        return gridData;
    }

    private Button initAccessModifierButton(Group accessModifierGroup, String accessModifierName, final VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
        Button accessModifierButton = new Button((Composite)accessModifierGroup, 16400);
        accessModifierButton.setText(accessModifierName);
        if (visibility.equals((Object)this.selectedVisibility)) {
            accessModifierButton.setSelection(true);
        }
        accessModifierButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EncapsulateFieldAccessorComposite.this.visibilitySelectionListener.visibilitySelected(visibility);
            }
        });
        return accessModifierButton;
    }

    private void initEnableDisableCheckBox(String name) {
        this.enableDisableCheckBox = new Button((Composite)this, 32);
        this.enableDisableCheckBox.setLayoutData((Object)this.getDefaultGridData());
        this.enableDisableCheckBox.setText(String.valueOf(Messages.EncapsulateFieldAccessorComposite_Generate) + name);
    }

    public void addEnableDisableListener(SelectionListener listener) {
        this.enableDisableCheckBox.addSelectionListener(listener);
    }

    public boolean isDisabled() {
        return this.enableDisableCheckBox != null ? !this.enableDisableCheckBox.getSelection() : false;
    }

    public void addVisibilitySelectionListener(IVisibilitySelectionListener visibilitySelectionListener) {
        this.visibilitySelectionListener = visibilitySelectionListener;
    }

    protected void checkSubclass() {
    }

    public void enableVisibilityGroup(boolean enabled) {
        this.publicButton.setEnabled(enabled);
        this.protectedButton.setEnabled(enabled);
        this.privateButton.setEnabled(enabled);
    }
}

