/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import java.util.Collection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.refactoring.core.splitlocal.ISplittedNamesReceiver;
import org.rubypeople.rdt.refactoring.core.splitlocal.LocalVarUsage;
import org.rubypeople.rdt.refactoring.core.splitlocal.SplitTempRefactoring;
import org.rubypeople.rdt.refactoring.ui.RdtCodeViewer;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.util.NameValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitLocalPage
extends RefactoringWizardPage {
    private static final int SEPARATOR_AT = 200;
    private static final int BORDER_WIDTH = 5;
    private static RGB[] colors = new RGB[]{new RGB(173, 193, 217), new RGB(223, 167, 166), new RGB(206, 221, 176), new RGB(191, 178, 207), new RGB(165, 213, 226), new RGB(250, 206, 170), new RGB(132, 162, 198), new RGB(207, 123, 121), new RGB(181, 204, 136), new RGB(159, 140, 183), new RGB(120, 192, 212), new RGB(247, 181, 128), new RGB(143, 164, 190)};
    private final Collection<LocalVarUsage> localUsages;
    private final String source;
    private final ISplittedNamesReceiver receiver;
    private Text[] names;

    public SplitLocalPage(Collection<LocalVarUsage> localUsages, String source, ISplittedNamesReceiver receiver) {
        super(String.valueOf(SplitTempRefactoring.NAME) + "...");
        this.localUsages = localUsages;
        this.source = source;
        this.receiver = receiver;
        this.setTitle(SplitTempRefactoring.NAME);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        FormLayout thisLayout = new FormLayout();
        main.setLayout((Layout)thisLayout);
        Composite variableNames = new Composite(main, 0);
        GridLayout variableNamesLayout = new GridLayout();
        variableNamesLayout.makeColumnsEqualWidth = true;
        FormData variableNamesLayoutData = new FormData();
        variableNamesLayoutData.top = new FormAttachment(0, 1000, 5);
        variableNamesLayoutData.bottom = new FormAttachment(1000, 1000, -5);
        variableNamesLayoutData.left = new FormAttachment(0, 1000, 5);
        variableNamesLayoutData.width = 185;
        variableNames.setLayoutData((Object)variableNamesLayoutData);
        variableNames.setLayout((Layout)variableNamesLayout);
        Label newNameLabel = new Label(variableNames, 0);
        newNameLabel.setText(Messages.SplitTempPage_ChooseNewNames);
        if (this.localUsages != null) {
            this.names = new Text[this.localUsages.size()];
            int i = 0;
            while (i < this.localUsages.size()) {
                Text text = new Text(variableNames, 2048);
                GridData textLData = new GridData();
                textLData.horizontalAlignment = 4;
                textLData.grabExcessHorizontalSpace = true;
                text.setLayoutData((Object)textLData);
                text.setText(this.localUsages.toArray(new LocalVarUsage[this.localUsages.size()])[i].getName());
                text.setBackground(new Color((Device)this.getShell().getDisplay(), colors[i]));
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        SplitLocalPage.this.setNewNames();
                    }
                });
                this.names[i] = text;
                ++i;
            }
            RdtCodeViewer sourceWidget = RdtCodeViewer.create(main);
            FormData layoutData = new FormData();
            layoutData.top = new FormAttachment(0, 1000, 5);
            layoutData.bottom = new FormAttachment(1000, 1000, -5);
            layoutData.right = new FormAttachment(1000, 1000, -5);
            layoutData.left = new FormAttachment(0, 1000, 200);
            sourceWidget.getTextWidget().setLayoutData((Object)layoutData);
            sourceWidget.getTextWidget().setText(this.source);
            int colorIndex = 0;
            for (LocalVarUsage var : this.localUsages) {
                sourceWidget.setBackgroundColor(var.getFromPosition(), var.getName().length(), colors[colorIndex++]);
            }
            this.setNewNames();
            sourceWidget.getTextWidget().setSelection(this.localUsages.toArray(new LocalVarUsage[this.localUsages.size()])[this.localUsages.size() - 1].getFromPosition());
        }
        main.layout();
        this.setControl((Control)main);
    }

    private void setNewNames() {
        assert (this.names.length == this.localUsages.size());
        String[] newNames = new String[this.localUsages.size()];
        boolean allOk = true;
        int i = 0;
        while (i < this.names.length) {
            if (this.names[i].getText().equals("")) {
                this.setErrorMessage(Messages.SplitTempPage_PleaseEnterName);
                allOk = false;
            } else if (!NameValidator.isValidLocalVariableName(this.names[i].getText())) {
                this.setErrorMessage(String.valueOf(this.names[i].getText()) + Messages.SplitTempPage_InvalidVariableName);
                allOk = false;
            }
            newNames[i] = this.names[i].getText();
            ++i;
        }
        this.setPageComplete(allOk);
        if (allOk) {
            this.setErrorMessage(null);
        }
        this.receiver.setNewNames(newNames);
    }
}

