/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.refactoring.core.movefield.MoveFieldConfig;
import org.rubypeople.rdt.refactoring.core.movefield.MoveFieldRefactoring;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;

public class MoveFieldPage
extends RefactoringWizardPage {
    private final MoveFieldConfig config;

    public MoveFieldPage(MoveFieldConfig config) {
        super(MoveFieldRefactoring.NAME);
        this.config = config;
        this.setTitle(MoveFieldRefactoring.NAME);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createTitleLabel(composite);
        this.createClassLabel(composite);
        this.createClassComboBox(composite);
        this.createReferenceLabel(composite);
        this.createReferenceComboBox(composite);
        this.setControl((Control)composite);
    }

    private void createReferenceComboBox(Composite composite) {
        Combo combobox = new Combo(composite, 12);
        combobox.setVisibleItemCount(10);
        for (String fieldName : this.config.getReferenceCandidates()) {
            if (this.config.getTargetReference() == null) {
                this.config.setTargetReference(fieldName);
                combobox.setText(fieldName);
            }
            combobox.add(fieldName);
        }
        combobox.select(0);
        combobox.addSelectionListener((SelectionListener)new ReferenceSelectionListener(combobox));
    }

    private void createReferenceLabel(Composite composite) {
        Label referenceLabel = new Label(composite, 0);
        referenceLabel.setText(Messages.MoveFieldPage_AccessibleBy);
    }

    private void createClassComboBox(Composite composite) {
        Combo combobox = new Combo(composite, 12);
        combobox.setVisibleItemCount(10);
        for (String name : this.config.getTargetClassCandidates()) {
            if (this.config.getTargetClass() == null) {
                this.config.setTargetClass(name);
            }
            combobox.add(name);
        }
        combobox.select(0);
        combobox.addSelectionListener((SelectionListener)new ClassNameSelectionListener(combobox));
    }

    private void createClassLabel(Composite composite) {
        Label moveToClassLabel = new Label(composite, 0);
        moveToClassLabel.setText(Messages.MoveFieldPage_MoveToClass);
    }

    private void createTitleLabel(Composite composite) {
        Label title = new Label(composite, 0);
        title.setText(String.valueOf(Messages.MoveFieldPage_Target) + this.config.getSelectedFieldName() + "':");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        title.setLayoutData((Object)gridData);
    }

    private final class ClassNameSelectionListener
    implements SelectionListener {
        private final Combo combo;

        public ClassNameSelectionListener(Combo combo) {
            this.combo = combo;
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            MoveFieldPage.this.config.setTargetClass(this.combo.getText());
        }
    }

    private final class ReferenceSelectionListener
    implements SelectionListener {
        private final Combo combo;

        public ReferenceSelectionListener(Combo combo) {
            this.combo = combo;
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            MoveFieldPage.this.config.setTargetReference(this.combo.getText());
        }
    }
}

