/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.mergewithexternalclassparts.ClassPartTreeItem;
import org.rubypeople.rdt.refactoring.core.mergewithexternalclassparts.ExternalClassPartsMerger;
import org.rubypeople.rdt.refactoring.ui.NotifiedContainerCheckedTree;
import org.rubypeople.rdt.refactoring.ui.RdtCodeViewer;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.ui.util.SwtUtils;

public class MergeWithExternalClassPartsPage
extends RefactoringWizardPage {
    private static final String TITLE = Messages.MergeWithExternalClassPartsPage_SelectParts;
    private NotifiedContainerCheckedTree tree;
    private ExternalClassPartsMerger merger;
    private RdtCodeViewer classView;

    public MergeWithExternalClassPartsPage(ExternalClassPartsMerger merger) {
        super(TITLE);
        this.setTitle(TITLE);
        this.merger = merger;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.initLayout(control);
    }

    private void initLayout(Composite control) {
        this.setControl((Control)control);
        FillLayout layout = new FillLayout(256);
        control.setLayout((Layout)layout);
        this.tree = this.initTree(control);
        Composite sidePanel = new Composite(control, 0);
        FillLayout sidePanelLayout = new FillLayout(512);
        sidePanel.setLayout((Layout)sidePanelLayout);
        String explTitle = Messages.MergeWithExternalClassPartsPage_Description;
        String explText = Messages.MergeWithExternalClassPartsPage_DescriptionText;
        SwtUtils.initExplanation(sidePanel, explTitle, explText);
        this.initClassPartView(sidePanel);
    }

    private void initClassPartView(Composite sidePanel) {
        this.classView = RdtCodeViewer.create(sidePanel);
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelectionProvider().getSelection();
                ClassPartTreeItem treeItem = (ClassPartTreeItem)selection.getFirstElement();
                Node classNode = treeItem.getClassPartWrapper().getWrappedNode();
                MergeWithExternalClassPartsPage.this.classView.setPreviewText(ReWriteVisitor.createCodeFromNode((Node)NodeFactory.createNewLineNode(classNode), (String)""));
            }
        });
    }

    private NotifiedContainerCheckedTree initTree(Composite c) {
        return new NotifiedContainerCheckedTree(c, this.merger, this.merger);
    }
}

