/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.mergeclasspartsinfile.MergeClassPartInFileConfig;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.RdtCodeViewer;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.ui.util.SwtUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeClassPartsInFilePage
extends RefactoringWizardPage {
    private static final String TITLE = Messages.MergeClassPartsInFilePage_SelectClassParts;
    private RdtCodeViewer classView;
    private String activeFileName;
    private MergeClassPartInFileConfig config;

    public MergeClassPartsInFilePage(MergeClassPartInFileConfig config) {
        super(TITLE);
        this.setTitle(TITLE);
        this.activeFileName = config.getDocumentProvider().getActiveFileName();
        this.config = config;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        FillLayout baseLayout = new FillLayout();
        baseLayout.spacing = 5;
        control.setLayout((Layout)baseLayout);
        this.initList(control);
        this.initSidePanel(control);
        this.setControl((Control)control);
    }

    private void initSidePanel(Composite control) {
        Composite sidePanel = new Composite(control, 0);
        FillLayout sidePanelLayout = new FillLayout(512);
        sidePanelLayout.spacing = 5;
        sidePanel.setLayout((Layout)sidePanelLayout);
        String explTitle = Messages.MergeClassPartsInFilePage_Description;
        String explText = Messages.MergeClassPartsInFilePage_Explanation;
        SwtUtils.initExplanation(sidePanel, explTitle, explText);
        this.classView = RdtCodeViewer.create(sidePanel);
    }

    private void initList(Composite control) {
        Composite listSide = new Composite(control, 0);
        FillLayout listSideLayout = new FillLayout(512);
        listSideLayout.spacing = 5;
        listSide.setLayout((Layout)listSideLayout);
        List classSelection = new List(listSide, 2820);
        Collection<ClassNodeWrapper> selectableClasses = this.config.getSelectableClasses();
        for (ClassNodeWrapper currentClass : selectableClasses) {
            classSelection.add(currentClass.getName());
        }
        Table partTable = new Table(listSide, 2852);
        classSelection.addSelectionListener(this.createClassSelectionListener(classSelection, selectableClasses, partTable));
        partTable.addListener(13, this.createPartSelectionListener(partTable));
    }

    private Listener createPartSelectionListener(final Table partTable) {
        return new Listener(){

            private void setClassView(Table partTable2) {
                TableItem selectedItem = partTable2.getSelection()[0];
                PartialClassNodeWrapper classPart = (PartialClassNodeWrapper)selectedItem.getData();
                Node classNode = classPart.getWrappedNode();
                MergeClassPartsInFilePage.this.classView.setPreviewText(ReWriteVisitor.createCodeFromNode((Node)NodeFactory.createNewLineNode(classNode), (String)""));
            }

            public void handleEvent(Event event) {
                ArrayList<PartialClassNodeWrapper> checkedParts = new ArrayList<PartialClassNodeWrapper>();
                TableItem[] tableItemArray = partTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem currentItem = tableItemArray[n2];
                    if (currentItem.getChecked()) {
                        checkedParts.add((PartialClassNodeWrapper)currentItem.getData());
                    }
                    ++n2;
                }
                partTable.setSelection((TableItem)event.item);
                this.setClassView(partTable);
                MergeClassPartsInFilePage.this.config.setCheckedClassParts(checkedParts);
                MergeClassPartsInFilePage.this.config.setSelectedClassPart((PartialClassNodeWrapper)partTable.getSelection()[0].getData());
            }
        };
    }

    private SelectionListener createClassSelectionListener(final List classSelection, final Collection<ClassNodeWrapper> selectableClasses, final Table partTable) {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (MergeClassPartsInFilePage.this.config.getSelectedClassPart() != null && classSelection.getSelection()[0].equals(MergeClassPartsInFilePage.this.config.getSelectedClassPart().getClassName())) {
                    return;
                }
                partTable.removeAll();
                String currentSelection = classSelection.getSelection()[0];
                for (ClassNodeWrapper currentClass : selectableClasses) {
                    if (currentClass.getName().equals(currentSelection)) {
                        this.fillClassPartTable(partTable, currentClass);
                    }
                    MergeClassPartsInFilePage.this.resetClassView();
                }
            }

            private void fillClassPartTable(Table partTable2, ClassNodeWrapper currentClass) {
                for (PartialClassNodeWrapper currentPart : currentClass.getPartialClassNodes()) {
                    if (!currentPart.getFile().equals(MergeClassPartsInFilePage.this.activeFileName)) continue;
                    TableItem currentItem = new TableItem(partTable2, 0);
                    currentItem.setData((Object)currentPart);
                    String itemText = this.createItemCaption(currentPart);
                    currentItem.setText(itemText.trim());
                }
            }

            private String createItemCaption(PartialClassNodeWrapper currentPart) {
                StringBuilder itemText = new StringBuilder();
                int lineCount = 0;
                for (MethodNodeWrapper method : currentPart.getMethods()) {
                    itemText.append(method.getSignature().getNameWithArgs()).append("\n");
                    if (lineCount >= 2) {
                        itemText.append("...");
                        break;
                    }
                    ++lineCount;
                }
                return itemText.toString();
            }
        };
    }

    private void resetClassView() {
        this.classView.setPreviewText("");
        this.config.setCheckedClassParts(new ArrayList<PartialClassNodeWrapper>());
        this.config.setSelectedClassPart(null);
    }
}

