/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.rubypeople.rdt.refactoring.core.inlineclass.InlineClassConfig;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;

public class InlineClassPage
extends RefactoringWizardPage {
    public static final String TITLE = Messages.InlineClassPage_InlineTemp;
    private InlineClassConfig config;

    public InlineClassPage(InlineClassConfig config) {
        super(TITLE);
        this.config = config;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.initBaseLayout(control);
        this.initList(control);
        this.setControl((Control)control);
    }

    private void initBaseLayout(Composite control) {
        GridLayout baseLayout = new GridLayout();
        baseLayout.numColumns = 1;
        control.setLayout((Layout)baseLayout);
    }

    private void initList(Composite control) {
        RowLayout panelLayout = new RowLayout(512);
        panelLayout.wrap = false;
        Label selectText = new Label(control, 0);
        selectText.setText(Messages.InlineClassPage_SelectTargetClass);
        List classList = new List(control, 2564);
        this.setListLayout(classList);
        this.fillList(classList);
        this.initSelectionListener(classList);
    }

    private void fillList(List classList) {
        for (ClassNodeWrapper currentClass : this.config.getPossibleTargetClasses()) {
            classList.add(currentClass.getName());
        }
    }

    private void setListLayout(List classList) {
        GridData listData = new GridData();
        listData.grabExcessHorizontalSpace = true;
        listData.grabExcessVerticalSpace = true;
        listData.horizontalAlignment = 4;
        listData.verticalAlignment = 4;
        classList.setLayoutData((Object)listData);
    }

    private void initSelectionListener(final List classList) {
        classList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String selection = classList.getSelection()[0];
                ClassNodeWrapper selectedClass = InlineClassPage.this.config.getDocumentProvider().getClassNodeProvider().getClassNode(selection);
                InlineClassPage.this.config.setTargetClassPart(selectedClass.getFirstPartialClassNode());
            }
        });
    }
}

