/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.internal.refactoring.RefactoringMessages;
import org.rubypeople.rdt.refactoring.core.extractconstant.ConstantExtractor;
import org.rubypeople.rdt.refactoring.ui.LabeledTextField;
import org.rubypeople.rdt.refactoring.util.NameValidator;

public class ExtractConstantPage
extends UserInputWizardPage {
    private ConstantExtractor extractor;

    public ExtractConstantPage(ConstantExtractor extractor) {
        super(RefactoringMessages.ExtractConstantWizard_defaultPageTitle);
        this.setDescription(RefactoringMessages.ExtractConstantInputPage_enter_name);
        this.extractor = extractor;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 8;
        control.setLayout((Layout)layout);
        final LabeledTextField labeledText = new LabeledTextField(control, RefactoringMessages.ExtractConstantInputPage_constant_name, this.extractor.getConstantName());
        GridData layoutData = new GridData(768);
        labeledText.setLayoutData(layoutData);
        labeledText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newName = labeledText.getText().getText();
                ExtractConstantPage.this.extractor.setConstantName(newName);
                this.checkInput(newName);
            }

            private void checkInput(String newName) {
                if (NameValidator.isValidConstantName(newName)) {
                    ExtractConstantPage.this.setMessage(null);
                    ExtractConstantPage.this.setPageComplete(true);
                } else {
                    ExtractConstantPage.this.setMessage(RefactoringMessages.bind((String)RefactoringMessages.ExtractConstantInputPage_invalid_name, (Object)newName), 3);
                    ExtractConstantPage.this.setPageComplete(false);
                }
            }
        });
        final Button replaceAllInstance = new Button(control, 32);
        GridData checkData = new GridData();
        replaceAllInstance.setLayoutData((Object)checkData);
        replaceAllInstance.setText(RefactoringMessages.ExtractConstantInputPage_replace_all_occurrences);
        replaceAllInstance.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExtractConstantPage.this.extractor.setReplaceAllInstances(replaceAllInstance.getSelection());
            }
        });
    }
}

