/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.rubypeople.rdt.refactoring.core.generateaccessors.AccessorsGenerator;
import org.rubypeople.rdt.refactoring.ui.NotifiedContainerCheckedTree;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.ui.util.SwtUtils;

public class AccessorSelectionPage
extends RefactoringWizardPage {
    private static final String title = Messages.AccessorSelectionPage_Title;
    private NotifiedContainerCheckedTree tree;
    private AccessorsGenerator accessorsGenerator;
    private static final int DEFAULT_TYPE = 1;

    public AccessorSelectionPage(AccessorsGenerator accessorsGenerator) {
        super(title);
        this.setTitle(title);
        this.accessorsGenerator = accessorsGenerator;
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FillLayout(256));
        this.initTree(c);
        Composite c2 = new Composite(c, 0);
        c2.setLayout((Layout)new FillLayout(512));
        this.initAccessorTypeSelection(c2);
        this.initTypeExamples(c2);
        this.setControl((Control)c);
    }

    private Widget[] initTypeExamples(Composite c) {
        Group simpleGroup = SwtUtils.initGroup(c, Messages.AccessorSelectionPage_SimpeAccessor);
        Label simpleLable = SwtUtils.initLabel(simpleGroup, Messages.AccessorSelectionPage_ExampleSimpleAccessor);
        Group methodGroup = SwtUtils.initGroup(c, Messages.AccessorSelectionPage_AccessorMethod);
        Label methodLabel = SwtUtils.initLabel(methodGroup, Messages.AccessorSelectionPage_ExampleAccessorMethod);
        return new Widget[]{simpleGroup, simpleLable, methodGroup, methodLabel};
    }

    private NotifiedContainerCheckedTree initTree(Composite c) {
        this.tree = new NotifiedContainerCheckedTree(c, this.accessorsGenerator, this.accessorsGenerator);
        return this.tree;
    }

    private Widget[] initAccessorTypeSelection(Composite parent) {
        Group g = new Group(parent, 512);
        g.setText(Messages.AccessorSelectionPage_SelectType);
        g.setBounds(200, 10, 300, 300);
        Button simpleButton = this.initTypeButton(Messages.AccessorSelectionPage_GenerateSimple, 1, g, 20);
        Button methodButton = this.initTypeButton(Messages.AccessorSelectionPage_GenerateMethods, 2, g, 40);
        return new Widget[]{g, simpleButton, methodButton};
    }

    private Button initTypeButton(String name, final int type, Group g, int y) {
        Button button = new Button((Composite)g, 16);
        button.setText(name);
        button.setBounds(15, y, 200, 20);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessorSelectionPage.this.setType(type);
            }
        });
        if (type == 1) {
            this.setType(type);
            button.setSelection(true);
        }
        return button;
    }

    protected void setType(int type) {
        this.accessorsGenerator.setType(type);
        this.tree.setInput("");
    }
}

