/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui;

import java.util.Collection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.refactoring.core.IValidator;
import org.rubypeople.rdt.refactoring.ui.IErrorMessageGenerator;
import org.rubypeople.rdt.refactoring.ui.IErrorMessageReceiver;
import org.rubypeople.rdt.refactoring.ui.INewNameReceiver;
import org.rubypeople.rdt.refactoring.ui.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewNameListener
implements IErrorMessageGenerator {
    private final INewNameReceiver receiver;
    private IErrorMessageReceiver errorReceiver;
    private final Collection<String> fields;
    private final IValidator validator;

    public NewNameListener(INewNameReceiver receiver, IValidator validator, Collection<String> fields) {
        this.receiver = receiver;
        this.validator = validator;
        this.fields = fields;
    }

    public void handleEvent(Event event) {
        String name;
        if (event.widget instanceof Text && this.isValid(name = ((Text)event.widget).getText())) {
            this.receiver.setNewName(name);
        }
    }

    private boolean isValid(String name) {
        boolean valid = this.validator.isValid(name);
        boolean nameAlreadyInUse = false;
        for (String field : this.fields) {
            if (!name.equals(field)) continue;
            nameAlreadyInUse = true;
        }
        if (valid && !nameAlreadyInUse) {
            this.errorReceiver.setError(null);
        } else if (nameAlreadyInUse) {
            this.errorReceiver.setError(String.valueOf(name) + Messages.NewNameListener_AlreadyInUse);
        } else {
            this.errorReceiver.setError(String.valueOf(name) + Messages.NewNameListener_IsNotValid);
        }
        return valid;
    }

    @Override
    public void setErrorReceiver(IErrorMessageReceiver errorReceiver) {
        this.errorReceiver = errorReceiver;
    }
}

