/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.signatureprovider;

import java.util.Collection;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.exception.UnknownClassNameException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.signatureprovider.ClassSignatureProvider;
import org.rubypeople.rdt.refactoring.signatureprovider.IClassSignatureProvider;
import org.rubypeople.rdt.refactoring.signatureprovider.MethodSignature;

public class ClassNodeSignatureProvider
extends ClassSignatureProvider {
    private ClassNodeWrapper classNode;

    public ClassNodeSignatureProvider(ClassNodeWrapper classNode, ClassNodeProvider classNodeProvider) {
        super(ClassNodeSignatureProvider.getSuperProvider(classNode, classNodeProvider));
        this.classNode = classNode;
        this.createMethodSignatures();
    }

    private void createMethodSignatures() {
        Collection<MethodNodeWrapper> methods = this.classNode.getMethods();
        for (MethodNodeWrapper method : methods) {
            this.addMethodSignature(method.getName(), method);
        }
    }

    public String getClassName() {
        return this.classNode.getName();
    }

    private static IClassSignatureProvider getSuperProvider(ClassNodeWrapper classNode, ClassNodeProvider classNodeProvider) {
        try {
            return ClassSignatureProvider.getClassSignatureProvider(classNode.getSuperClassName(), classNodeProvider);
        }
        catch (UnknownClassNameException unknownClassNameException) {
            return null;
        }
    }

    protected MethodSignature getSignature(String methodName, Object data) {
        return ((MethodNodeWrapper)data).getSignature();
    }
}

