/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.offsetprovider;

import java.util.Collection;
import org.jruby.ast.DefnNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.OffsetProvider;

public class ConstructorOffsetProvider
extends OffsetProvider {
    private PartialClassNodeWrapper classPart;

    public ConstructorOffsetProvider(ClassNodeWrapper classNode, String document) {
        this(classNode.getFirstPartialClassNode(), document);
    }

    public ConstructorOffsetProvider(PartialClassNodeWrapper classPart, String document) {
        super(document);
        this.classPart = classPart;
    }

    public Node getInsertAfterNode() {
        Node contentNode = this.classPart.getClassBodyNode();
        if (contentNode != null) {
            if (NodeProvider.hasChildNode(contentNode, DefnNode.class)) {
                Collection<MethodNodeWrapper> constructors = this.classPart.getExistingConstructors();
                if (constructors.isEmpty()) {
                    Node firstMethodNode = NodeProvider.getFirstChildNode(contentNode, DefnNode.class);
                    if (NodeProvider.hasNodeBefore(contentNode, firstMethodNode)) {
                        Node nodeBefore = NodeProvider.getNodeBefore(contentNode, firstMethodNode);
                        return nodeBefore;
                    }
                    return this.classPart.getDeclarationEndNode();
                }
                MethodNodeWrapper lastConstructor = constructors.toArray(new MethodNodeWrapper[constructors.size()])[constructors.size() - 1];
                return lastConstructor.getWrappedNode();
            }
            return this.getLastContentNode(this.classPart);
        }
        return this.classPart.getDeclarationEndNode();
    }
}

