/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNodeWrapper
implements INodeWrapper {
    private final ModuleNode moduleNode;
    private ModuleNodeWrapper parentModule;
    private ArrayList<ConstNode> moduleMethodNodes = new ArrayList();

    public ModuleNodeWrapper(ModuleNode moduleNode, ModuleNodeWrapper parentModule) {
        this.moduleNode = moduleNode;
        this.parentModule = parentModule;
        this.initModuleMethodConstNodes();
    }

    public ModuleNode getWrappedNode() {
        return this.moduleNode;
    }

    public ModuleNodeWrapper getParentModule() {
        return this.parentModule;
    }

    public void setParentModule(ModuleNodeWrapper parentModule) {
        this.parentModule = parentModule;
    }

    public String getName() {
        return this.moduleNode.getCPath().getName();
    }

    public String getFullName() {
        return String.valueOf(this.parentModule != null ? String.valueOf(this.parentModule.getFullName()) + "::" : "") + this.getName();
    }

    public Collection<ConstNode> getModuleMethodConstNodes() {
        return this.moduleMethodNodes;
    }

    private void initModuleMethodConstNodes() {
        for (Node node : NodeProvider.getSubNodes((Node)this.getWrappedNode(), DefsNode.class)) {
            ConstNode constNode;
            DefsNode defsNode = (DefsNode)node;
            if (!(defsNode.getReceiverNode() instanceof ConstNode) || !(constNode = (ConstNode)defsNode.getReceiverNode()).getName().equals(this.getName())) continue;
            this.moduleMethodNodes.add(constNode);
        }
    }
}

