/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class MethodCallNodeWrapper
implements INodeWrapper {
    static final Class[] METHOD_CALL_NODE_CLASSES = new Class[]{CallNode.class, VCallNode.class, FCallNode.class, AttrAssignNode.class};
    public static final int INVALID_TYPE = -1;
    public static final int CALL_NODE = 1;
    public static final int V_CALL_NODE = 2;
    public static final int F_CALL_NODE = 3;
    private int nodeType;
    private Node wrappedNode;
    private Node receiverNode;
    private Node argsNode;
    private String name;

    public MethodCallNodeWrapper(Node node) {
        this.wrappedNode = node;
        if (NodeUtil.nodeAssignableFrom(node, CallNode.class)) {
            CallNode callNode = (CallNode)node;
            this.nodeType = 1;
            this.receiverNode = callNode.getReceiverNode();
            this.argsNode = callNode.getArgsNode();
            this.name = callNode.getName();
        } else if (NodeUtil.nodeAssignableFrom(node, AttrAssignNode.class)) {
            AttrAssignNode callNode = (AttrAssignNode)node;
            this.nodeType = 1;
            this.receiverNode = callNode.getReceiverNode();
            this.argsNode = callNode.getArgsNode();
            this.name = callNode.getName();
        } else if (NodeUtil.nodeAssignableFrom(node, VCallNode.class)) {
            this.nodeType = 2;
            this.name = ((VCallNode)node).getName();
        } else if (NodeUtil.nodeAssignableFrom(node, FCallNode.class)) {
            FCallNode fCallNode = (FCallNode)node;
            this.nodeType = 3;
            this.name = fCallNode.getName();
            this.argsNode = fCallNode.getArgsNode();
        } else {
            this.nodeType = -1;
        }
    }

    public boolean isCallNode() {
        return this.nodeType == 1;
    }

    public boolean isVCallNode() {
        return this.nodeType == 2;
    }

    public boolean isFCallNode() {
        return this.nodeType == 3;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.getPosition().getFile();
    }

    public ISourcePosition getPosition() {
        return this.wrappedNode.getPosition();
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public int getType() {
        return this.nodeType;
    }

    public boolean isCallToClassMethod() {
        return NodeUtil.nodeAssignableFrom(this.receiverNode, ConstNode.class);
    }

    public Node getWrappedNode() {
        return this.wrappedNode;
    }

    public int getArgsCount() {
        if (this.argsNode == null) {
            return 0;
        }
        return this.argsNode.childNodes().size();
    }

    public String getReceiverName() {
        if (this.receiverNode instanceof INameNode) {
            return ((INameNode)this.receiverNode).getName();
        }
        return null;
    }

    public static Class[] METHOD_CALL_NODE_CLASSES() {
        return (Class[])METHOD_CALL_NODE_CLASSES.clone();
    }
}

