/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.SplatNode;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class CallArgsNodeWrapper
implements INodeWrapper {
    private SplatNode splatNode;
    private ArrayNode arrayNode;
    private Node wrappedNode;

    public CallArgsNodeWrapper(Node node) {
        this.wrappedNode = node;
        if (NodeUtil.nodeAssignableFrom(node, ArrayNode.class)) {
            this.arrayNode = (ArrayNode)node;
        } else if (NodeUtil.nodeAssignableFrom(node, SplatNode.class)) {
            this.splatNode = (SplatNode)node;
        } else if (NodeUtil.nodeAssignableFrom(node, ArgsCatNode.class)) {
            ArgsCatNode argsCatNode = (ArgsCatNode)node;
            this.arrayNode = (ArrayNode)argsCatNode.getFirstNode();
            this.splatNode = (SplatNode)argsCatNode.getSecondNode();
        }
    }

    public boolean hasSplatNode() {
        return this.splatNode != null;
    }

    public boolean hasArrayNode() {
        return this.arrayNode != null;
    }

    public Node cloneWithAddedArg(Node addedArg) {
        ArrayNode newArrayNode = this.getNewArrayNode(addedArg);
        if (this.hasSplatNode()) {
            return NodeFactory.createArgsCatNode((Node)newArrayNode, (Node)this.splatNode);
        }
        return newArrayNode;
    }

    private ArrayNode getNewArrayNode(Node addedArg) {
        ArrayList<Node> newArrayChilds = new ArrayList<Node>();
        if (this.hasArrayNode()) {
            for (Object obj : this.arrayNode.childNodes()) {
                newArrayChilds.add((Node)obj);
            }
        }
        newArrayChilds.add(addedArg);
        return NodeFactory.createArrayNode(newArrayChilds);
    }

    public Node getWrappedNode() {
        return this.wrappedNode;
    }
}

