/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.editprovider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.TextEdit;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.util.FileHelper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class DeleteEditProvider
extends EditProvider {
    public static final int DELETE_LINEBREAK_AFTER = 0;
    public static final int DELETE_LINEBREAK_BEFORE = 1;
    public static final int DEFAULT_DELETE_TYPE = 1;
    private Node fromNode;
    private Node toNode;
    private int type;

    public DeleteEditProvider(Node fromNode, Node toNode) {
        super(true, false);
        this.fromNode = fromNode;
        this.toNode = toNode;
        this.type = 1;
    }

    public DeleteEditProvider(Node node) {
        this(node, node);
    }

    public TextEdit getEdit(String document) {
        int startOffset = this.getStartOffset(document);
        int endOffset = this.getEndOffset(document);
        int length = endOffset - startOffset;
        return new DeleteEdit(startOffset, length);
    }

    private int getStartOffset(String document) {
        String leadingStr;
        int startLine = NodeUtil.subPositionUnion(this.fromNode).getStartLine();
        int pos = -1;
        String lineDelimiter = FileHelper.getLineDelimiter(document);
        int i = 0;
        while (i < startLine) {
            pos = document.indexOf(lineDelimiter, pos + 1);
            ++i;
        }
        if (pos < 0) {
            pos = 0;
        }
        if ((leadingStr = document.substring(pos, NodeUtil.subPositionUnion(this.fromNode).getStartOffset())).trim().equals("")) {
            return pos;
        }
        return NodeUtil.subPositionUnion(this.fromNode).getStartOffset();
    }

    private int getEndOffset(String document) {
        int offset;
        int aktPos = offset = NodeUtil.subPositionUnion(this.toNode).getEndOffset();
        Matcher matcher = Pattern.compile("\\r\\n|[\\s;]").matcher(document);
        String lineDelimiter = FileHelper.getLineDelimiter(document);
        while (matcher.find(aktPos)) {
            if (matcher.start() == aktPos) {
                aktPos += matcher.group().length();
            } else {
                offset = aktPos;
                break;
            }
            if (this.foundTerminator(matcher.group())) break;
        }
        if (this.type != 0 && matcher.find(offset) && matcher.group().equals(lineDelimiter)) {
            aktPos -= lineDelimiter.length();
        }
        return aktPos;
    }

    private boolean foundTerminator(String terminator) {
        return terminator.equals(Character.toString('\n')) || terminator.equals(";");
    }

    protected Node getEditNode(int offset, String document) {
        return null;
    }

    protected int getOffset(String document) {
        return Integer.MAX_VALUE;
    }

    public void setDeleteType(int deleteType) {
        this.type = deleteType;
    }
}

