/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.documentprovider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.util.Util;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceDocumentProvider
extends DocumentProvider {
    private IFile activeFile;
    private String activeFileContent;
    private IProject activeProject;
    private IWorkspaceRoot workspaceRoot;

    public WorkspaceDocumentProvider(IFile activeFile) {
        this.activeFile = activeFile;
        this.activeProject = activeFile.getProject();
        this.workspaceRoot = this.activeFile.getWorkspace().getRoot();
        this.activeFileContent = this.getFileContent(this.getActiveFileName());
    }

    @Override
    public String getActiveFileContent() {
        return this.activeFileContent;
    }

    @Override
    public String getActiveFileName() {
        return this.activeFile.getFullPath().toOSString();
    }

    public IFile getIFile(String fileName) {
        fileName = this.makePathAbsoulte(fileName);
        return this.workspaceRoot.getFile((IPath)new Path(fileName));
    }

    @Override
    public Collection<String> getFileNames() {
        ArrayList<String> fileNames = new ArrayList<String>();
        this.fillFileNames(fileNames, (IContainer)this.activeProject);
        return fileNames;
    }

    private void fillFileNames(ArrayList<String> fileNames, IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile currentFile;
                String fileExtension;
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 1 && (fileExtension = (currentFile = (IFile)resource).getFileExtension()) != null && fileExtension.equals("rb")) {
                    fileNames.add(currentFile.getFullPath().toOSString());
                }
                if (resource instanceof IContainer) {
                    IContainer subContainer = (IContainer)resource;
                    this.fillFileNames(fileNames, subContainer);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getFileContent(String fileName) {
        IFile currentFile = this.getIFile(fileName);
        try {
            return new String(Util.getResourceContentsAsCharArray((IFile)currentFile));
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
    }

    private String makePathAbsoulte(String path) {
        Path absolutePath = new Path(path);
        if (absolutePath.isAbsolute()) {
            return absolutePath.toOSString();
        }
        return this.activeFile.getFullPath().removeLastSegments(1).append(path).toOSString();
    }
}

