/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamemethod;

import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.IValidator;
import org.rubypeople.rdt.refactoring.core.RubyRefactoring;
import org.rubypeople.rdt.refactoring.core.renamemethod.Messages;
import org.rubypeople.rdt.refactoring.core.renamemethod.MethodRenamer;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConfig;
import org.rubypeople.rdt.refactoring.ui.NewNameListener;
import org.rubypeople.rdt.refactoring.ui.pages.OccurenceReplaceSelectionPage;
import org.rubypeople.rdt.refactoring.ui.pages.RenamePage;
import org.rubypeople.rdt.refactoring.util.NameValidator;

public class RenameMethodRefactoring
extends RubyRefactoring {
    public static final String NAME = Messages.RenameMethodRefactoring_Name;

    public RenameMethodRefactoring(IRefactoringContext selectionProvider) {
        super(NAME, selectionProvider);
        RenameMethodConfig config = new RenameMethodConfig(this.getDocumentProvider(), selectionProvider.getCaretPosition());
        RenameMethodConditionChecker checker = new RenameMethodConditionChecker(config);
        this.setRefactoringConditionChecker(checker);
        if (checker.shouldPerform()) {
            MethodRenamer methodRenamer = new MethodRenamer(config);
            this.setEditProvider(methodRenamer);
            NewNameListener nameListener = new NewNameListener(config, new MethodNameValidator(), checker.getAlreadyUsedNames());
            RenamePage page = new RenamePage(String.valueOf(NAME) + "...", config.getTargetMethod().getName(), nameListener);
            this.pages.add(page);
            if (!config.getPossibleCalls().isEmpty()) {
                this.pages.add(new OccurenceReplaceSelectionPage(config, config.getDocumentProvider()));
            }
        }
    }

    private static final class MethodNameValidator
    implements IValidator {
        private MethodNameValidator() {
        }

        public boolean isValid(String test) {
            return NameValidator.isValidMethodName(test);
        }
    }
}

