/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamemethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SymbolNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.FieldProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.InstVarAccessesFinder;
import org.rubypeople.rdt.refactoring.core.renamemethod.Messages;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConfig;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentWithIncluding;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameMethodConditionChecker
extends RefactoringConditionChecker {
    public static final String DEFAULT_ERROR = Messages.RenameMethodConditionChecker_NoMethodSelected;
    private RenameMethodConfig config;

    public RenameMethodConditionChecker(RenameMethodConfig config) {
        super(config);
    }

    @Override
    public void init(IRefactoringConfig configObj) {
        this.config = (RenameMethodConfig)configObj;
        this.config.setDocProvider(new DocumentWithIncluding(this.config.getDocumentProvider()));
        RootNode rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        try {
            this.config.setClassNode(SelectionNodeProvider.getSelectedClassNode((Node)rootNode, this.config.getCaretPosition()));
        }
        catch (NoClassNodeException noClassNodeException) {}
        this.setSelectedMethodNode((Node)rootNode);
        if (this.config.getTargetMethod().getWrappedNode() != null) {
            this.config.setPossibleCalls(this.getAllCallCandidates());
        }
    }

    private void setSelectedMethodNode(Node rootNode) {
        MethodNodeWrapper method;
        SymbolNode selectedSymbolNode;
        MethodDefNode methodNode = (MethodDefNode)SelectionNodeProvider.getSelectedNodeOfType(rootNode, this.config.getCaretPosition(), MethodDefNode.class);
        if (methodNode == null && (selectedSymbolNode = (SymbolNode)SelectionNodeProvider.getSelectedNodeOfType(rootNode, this.config.getCaretPosition(), SymbolNode.class)) != null && this.config.getSelectedClass() != null && (method = this.config.getSelectedClass().getMethod(selectedSymbolNode.getName())) != null) {
            methodNode = method.getWrappedNode();
        }
        MethodNodeWrapper targetMethod = new MethodNodeWrapper(methodNode, this.config.getSelectedClass());
        this.config.setTargetMethod(targetMethod);
        if (methodNode != null && this.config.getNewName() == null) {
            this.config.setNewName(targetMethod.getName());
        }
    }

    private Collection<INodeWrapper> getAllCallCandidates() {
        Collection<Node> allNodes = this.config.getDocumentProvider().getAllNodes();
        ArrayList<INodeWrapper> possibleCalls = new ArrayList<INodeWrapper>();
        for (Node currentNode : allNodes) {
            MethodCallNodeWrapper callNode = new MethodCallNodeWrapper(currentNode);
            if (!this.isPossibleCall(callNode)) continue;
            possibleCalls.add(callNode);
        }
        if (this.config.getTargetMethod().isAccessor() && this.config.renameFields()) {
            String name = this.config.getTargetMethod().isWriter() ? this.config.getTargetMethod().getName().replace("=", "") : this.config.getTargetMethod().getName();
            possibleCalls.addAll(InstVarAccessesFinder.find(this.config.getDocumentProvider(), name));
            possibleCalls.addAll(new FieldProvider(this.config.getSelectedClass(), this.config.getDocumentProvider()).getFieldItems(name, false));
            this.config.setSelectedCalls(new FieldProvider(this.config.getSelectedClass(), this.config.getDocumentProvider()).getFieldItems(name, false));
        }
        return possibleCalls;
    }

    private boolean isPossibleCall(MethodCallNodeWrapper callNode) {
        ArgsNodeWrapper targetNodeArgs;
        if (this.config.getTargetMethod().isClassMethod() != callNode.isCallToClassMethod()) {
            return false;
        }
        if (callNode.getType() == -1) {
            return false;
        }
        return callNode.getName().equals(this.config.getTargetMethod().getName()) && (targetNodeArgs = this.config.getTargetMethod().getArgsNode()).argsCountMatches(callNode);
    }

    @Override
    protected void checkFinalConditions() {
        if (this.config.getNewName().equals(this.config.getTargetMethod().getName())) {
            this.addWarning(Messages.RenameMethodConditionChecker_NotChanged);
        } else if (this.getAlreadyUsedNames().contains(this.config.getNewName())) {
            this.addError(Messages.RenameMethodConditionChecker_AlreadyExists);
        }
    }

    private boolean checkMethodIsBeyondClasses(MethodDefNode currentMethod, ClassNodeProvider classes) {
        String methodFile = currentMethod.getPosition().getFile();
        int methodStart = currentMethod.getPosition().getStartOffset();
        int methodEnd = currentMethod.getPosition().getEndOffset();
        for (ClassNodeWrapper currentClass : classes.getAllClassNodes()) {
            for (PartialClassNodeWrapper currentPart : currentClass.getPartialClassNodes()) {
                if (!this.checkIsInClassPart(methodFile, methodStart, methodEnd, currentPart)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkIsInClassPart(String methodFile, int methodStart, int methodEnd, PartialClassNodeWrapper currentPart) {
        String partFile = currentPart.getWrappedNode().getPosition().getFile();
        int partStart = currentPart.getWrappedNode().getPosition().getStartOffset();
        int partEnd = currentPart.getWrappedNode().getPosition().getEndOffset();
        return methodFile.equals(partFile) && methodStart > partStart && methodEnd < partEnd;
    }

    @Override
    protected void checkInitialConditions() {
        MethodDefNode methodNode = this.config.getTargetMethod().getWrappedNode();
        if (methodNode == null || !this.isSelectionInMethodName()) {
            this.addError(DEFAULT_ERROR);
        }
    }

    private boolean isSelectionInMethodName() {
        return SelectionNodeProvider.nodeContainsPosition((Node)this.config.getTargetMethod().getWrappedNode().getNameNode(), this.config.getCaretPosition());
    }

    public Collection<String> getAlreadyUsedNames() {
        HashSet<String> usedNames = new HashSet<String>();
        if (this.config.getSelectedClass() != null) {
            for (MethodNodeWrapper currentMethod : this.config.getSelectedClass().getMethods()) {
                if (!this.isSameTypeAsSelectedMethod(currentMethod)) continue;
                usedNames.add(currentMethod.getName());
            }
        } else {
            RootNode rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
            Collection<MethodDefNode> methods = NodeProvider.getMethodNodes((Node)rootNode);
            ClassNodeProvider classes = new ClassNodeProvider(this.config.getDocumentProvider());
            for (MethodDefNode currentMethod : methods) {
                if (!this.checkMethodIsBeyondClasses(currentMethod, classes)) continue;
                usedNames.add(currentMethod.getName());
            }
        }
        return usedNames;
    }

    private boolean isSameTypeAsSelectedMethod(MethodNodeWrapper currentMethod) {
        return currentMethod.isClassMethod() == this.config.getTargetMethod().isClassMethod();
    }
}

