/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamelocal;

import java.util.ArrayList;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.renamelocal.IAbortCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableRenamer {
    protected final String oldName;
    protected final String newName;
    protected final IAbortCondition abort;

    public VariableRenamer(String oldName, String newName, IAbortCondition abort) {
        this.oldName = oldName;
        this.newName = newName;
        this.abort = abort;
    }

    private boolean isRenamedVariableRestArg(ArgsNode args, String[] localNames) {
        return args.getRestArg() > 0 && args.getRestArg() < localNames.length && localNames[args.getRestArg()].equals(this.oldName);
    }

    public ArrayList<Node> replaceVariableNamesInNode(Node n, String[] localNames) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (n instanceof MethodDefNode) {
            nodes.addAll(this.replaceVariableNames((Node)((MethodDefNode)n).getArgsNode()));
            nodes.addAll(this.replaceVariableNames(((MethodDefNode)n).getBodyNode()));
        } else {
            nodes.addAll(this.replaceVariableNames(n));
        }
        if (n instanceof MethodDefNode && this.isRenamedVariableRestArg(((MethodDefNode)n).getArgsNode(), localNames)) {
            MethodDefNode defn = (MethodDefNode)n;
            nodes.add((Node)defn.getArgsNode());
            localNames[defn.getArgsNode().getRestArg()] = this.newName;
        }
        return nodes;
    }

    private ArrayList<Node> replaceVariableNames(Node n) {
        ArrayList<Node> renamedNodes = new ArrayList<Node>();
        if (n == null || this.abort.abort(n)) {
            return renamedNodes;
        }
        if (n instanceof INameNode && ((INameNode)n).getName().equals(this.oldName)) {
            renamedNodes.add(n);
            if (n instanceof LocalAsgnNode) {
                ((LocalAsgnNode)n).setName(this.newName);
                this.replaceVariableNames(((LocalAsgnNode)n).getValueNode());
                return renamedNodes;
            }
            if (n instanceof ArgumentNode) {
                ((ArgumentNode)n).setName(this.newName);
            } else if (n instanceof LocalVarNode) {
                ((LocalVarNode)n).setName(this.newName);
            } else if (n instanceof BlockArgNode) {
                ((BlockArgNode)n).setName(this.newName);
            }
        }
        for (Object node : n.childNodes()) {
            renamedNodes.addAll(this.replaceVariableNames((Node)node));
        }
        return renamedNodes;
    }
}

