/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamefield;

import java.util.Collection;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.renamefield.FieldRenameEditProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConfig;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.FieldItem;
import org.rubypeople.rdt.refactoring.core.renamemethod.MethodRenamer;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConfig;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiFileEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldRenamer
implements IMultiFileEditProvider {
    private RenameFieldConfig config;

    public FieldRenamer(RenameFieldConfig config) {
        this.config = config;
    }

    @Override
    public Collection<FileMultiEditProvider> getFileEditProviders() {
        MultiFileEditProvider fileEdits = new MultiFileEditProvider();
        for (INodeWrapper iNodeWrapper : this.config.getSelectedCalls()) {
            String file = iNodeWrapper.getWrappedNode().getPosition().getFile();
            FieldRenameEditProvider currentRenameProvider = new FieldRenameEditProvider((FieldItem)iNodeWrapper, this.config.getNewName());
            fileEdits.addEditProvider(new FileEditProvider(file, currentRenameProvider));
        }
        if (this.config.doRenameAccessorMethods()) {
            this.addAccessorMethodRenamers(fileEdits);
        }
        return fileEdits.getFileEditProviders();
    }

    private void addAccessorMethodRenamers(MultiFileEditProvider fileEdits) {
        ClassNodeWrapper wholeClass = this.config.getWholeClassNode();
        Collection<MethodNodeWrapper> methods = wholeClass.getMethods();
        for (MethodNodeWrapper currentMethod : methods) {
            MethodRenamer methodRenamer;
            ISourcePosition methodPosition = currentMethod.getWrappedNode().getPosition();
            RenameMethodConfig methodConfig = new RenameMethodConfig(this.config.getDocumentProvider(), methodPosition.getStartOffset());
            new RenameMethodConditionChecker(methodConfig);
            methodConfig.setRenameFields(false);
            if (currentMethod.getName().equals(this.config.getSelectedName())) {
                methodConfig.setNewName(this.config.getNewName());
                methodRenamer = new MethodRenamer(methodConfig);
                this.addMethodEditProviders(fileEdits, methodRenamer);
                continue;
            }
            if (!currentMethod.getName().equals(String.valueOf(this.config.getSelectedName()) + '=')) continue;
            methodConfig.setNewName(String.valueOf(this.config.getNewName()) + "=");
            methodRenamer = new MethodRenamer(methodConfig);
            this.addMethodEditProviders(fileEdits, methodRenamer);
        }
    }

    private void addMethodEditProviders(MultiFileEditProvider fileEdits, MethodRenamer methodRenamer) {
        Collection<FileMultiEditProvider> methodEdits = methodRenamer.getFileEditProviders();
        for (FileMultiEditProvider currentEditProvider : methodEdits) {
            this.putEditProvider(fileEdits, currentEditProvider);
        }
    }

    private void putEditProvider(MultiFileEditProvider fileEdits, FileMultiEditProvider multiEditProvider) {
        String file = multiEditProvider.getFileName();
        Collection<EditProvider> editProviders = multiEditProvider.getEditProviders();
        for (EditProvider currentEditProvider : editProviders) {
            fileEdits.addEditProvider(new FileEditProvider(file, currentEditProvider));
        }
    }
}

