/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renameclass;

import org.jruby.ast.ClassNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.renameclass.Messages;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassConfig;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentWithIncluding;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class RenameClassConditionChecker
extends RefactoringConditionChecker {
    public static final String DEFAULT_ERROR = Messages.RenameClassConditionChecker_PleaseSelectNameOfAClassDeclaration;
    private RenameClassConfig config;

    public RenameClassConditionChecker(RenameClassConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (RenameClassConfig)configObj;
        this.config.setDocumentWithIncludingProvider(new DocumentWithIncluding(this.config.getDocumentProvider()));
        ClassNodeWrapper classNode = null;
        try {
            classNode = SelectionNodeProvider.getSelectedClassNode((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.config.getOffset());
            if (!NodeUtil.positionIsInNode(this.config.getOffset(), ((ClassNode)classNode.getWrappedNode()).getCPath())) {
                return;
            }
        }
        catch (NoClassNodeException noClassNodeException) {
            return;
        }
        String modulePrefix = classNode.getFirstPartialClassNode().getModulePrefix();
        if ("".equals(modulePrefix)) {
            this.config.setModulePrefix("");
        } else {
            this.config.setModulePrefix(String.valueOf(modulePrefix) + "::");
        }
        this.config.setSelectedNode((ClassNode)classNode.getFirstPartialClassNode().getWrappedNode());
        this.config.setNewName(classNode.getName());
    }

    protected void checkInitialConditions() {
        if (this.config.getSelectedNode() == null) {
            this.addError(DEFAULT_ERROR);
        }
    }
}

