/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renameclass;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.renameclass.ConstructorCall;
import org.rubypeople.rdt.refactoring.editprovider.FileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.ReplaceEditProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorRenameEditProvider {
    private final Collection<ConstructorCall> calls;
    private final String newName;

    public ConstructorRenameEditProvider(Collection<ConstructorCall> calls, String newName) {
        this.calls = calls;
        this.newName = newName;
    }

    protected Collection<FileEditProvider> getEditProviders() {
        ArrayList<FileEditProvider> edits = new ArrayList<FileEditProvider>();
        for (ConstructorCall call : this.calls) {
            call.setName(this.newName);
            edits.add(new FileEditProvider(call.getNode().getPosition().getFile(), new ConstructorEditProvider(call)));
        }
        return edits;
    }

    private static class ConstructorEditProvider
    extends ReplaceEditProvider {
        private final ConstructorCall call;

        public ConstructorEditProvider(ConstructorCall call) {
            this.call = call;
        }

        protected int getOffsetLength() {
            return this.call.getReceiverLength();
        }

        protected Node getEditNode(int offset, String document) {
            return this.call.getNode().getReceiverNode();
        }

        protected int getOffset(String document) {
            return this.call.getReceiverOffset();
        }
    }
}

