/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renameclass;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.ClassNode;
import org.rubypeople.rdt.refactoring.core.renameclass.IClassFinder;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder
implements IClassFinder {
    private final String name;
    private Collection<ClassNodeWrapper> classNodes;
    private String modulePrefix;

    public ClassFinder(IDocumentProvider doc, String name, String modulePrefix) {
        this.name = name;
        this.modulePrefix = modulePrefix;
        this.classNodes = new ArrayList<ClassNodeWrapper>();
        this.classNodes.addAll(doc.getProjectClassNodeProvider().getAllClassNodes());
    }

    private Collection<ClassNode> find(INodeAcceptor acceptor) {
        ArrayList<ClassNode> found = new ArrayList<ClassNode>();
        for (ClassNodeWrapper classNode : this.classNodes) {
            for (PartialClassNodeWrapper node : classNode.getPartialClassNodes()) {
                if (!acceptor.accept(node)) continue;
                found.add((ClassNode)node.getWrappedNode());
            }
        }
        return found;
    }

    @Override
    public Collection<ClassNode> findParts() {
        return this.find(new INodeAcceptor(){

            public boolean accept(PartialClassNodeWrapper node) {
                return node.getClassName().equals(String.valueOf(ClassFinder.this.modulePrefix) + ClassFinder.this.name);
            }
        });
    }

    @Override
    public Collection<ClassNode> findChildren() {
        return this.find(new INodeAcceptor(){

            public boolean accept(PartialClassNodeWrapper node) {
                String fullName = node.getModulePrefix();
                if (!"".equals(fullName)) {
                    fullName = String.valueOf(fullName) + "::";
                }
                fullName = String.valueOf(fullName) + node.getSuperClassName();
                return fullName.equals(String.valueOf(ClassFinder.this.modulePrefix) + ClassFinder.this.name);
            }
        });
    }

    private static interface INodeAcceptor {
        public boolean accept(PartialClassNodeWrapper var1);
    }
}

