/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.rename;

import org.eclipse.jface.wizard.IWizardPage;
import org.rubypeople.rdt.refactoring.core.IRefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.RubyRefactoring;
import org.rubypeople.rdt.refactoring.core.rename.Messages;
import org.rubypeople.rdt.refactoring.core.rename.RenameConditionChecker;
import org.rubypeople.rdt.refactoring.core.rename.RenameConfig;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassRefactoring;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldRefactoring;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalRefactoring;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodRefactoring;
import org.rubypeople.rdt.refactoring.core.renamemodule.RenameModuleRefactoring;

public class RenameRefactoring
extends RubyRefactoring {
    public static final String NAME = Messages.RenameRefactoring_Name;
    private RubyRefactoring delegateRenameRefactoring;
    private IRefactoringContext selectionProvider;

    public RenameRefactoring(IRefactoringContext selectionProvider) {
        super(NAME, selectionProvider);
        RenameConfig config = new RenameConfig(this.getDocumentProvider(), selectionProvider.getCaretPosition());
        RenameConditionChecker checker = new RenameConditionChecker(config);
        this.setRefactoringConditionChecker(checker);
        if (checker.shouldPerform()) {
            if (checker.shouldRenameLocal()) {
                this.delegateRenameRefactoring = new RenameLocalRefactoring(selectionProvider);
            } else if (checker.shouldRenameField()) {
                this.delegateRenameRefactoring = new RenameFieldRefactoring(selectionProvider);
            } else if (checker.shouldRenameMethod()) {
                this.delegateRenameRefactoring = new RenameMethodRefactoring(selectionProvider);
            } else if (checker.shouldRenameClass()) {
                this.delegateRenameRefactoring = new RenameClassRefactoring(selectionProvider);
            } else if (checker.shouldRenameModule()) {
                this.delegateRenameRefactoring = new RenameModuleRefactoring(selectionProvider);
            }
            IRefactoringConditionChecker delegateConditionChecker = this.delegateRenameRefactoring.getConditionChecker();
            this.setRefactoringConditionChecker(delegateConditionChecker);
            if (delegateConditionChecker.shouldPerform()) {
                this.setName(this.delegateRenameRefactoring.getName());
                this.setEditProvider(this.delegateRenameRefactoring.getMultiFileEditProvider());
                this.setEditProvider(this.delegateRenameRefactoring.getEditProvider());
                this.setFileNameChangeProvider(this.delegateRenameRefactoring.getFileNameChangeProvider());
                for (IWizardPage aktPage : this.delegateRenameRefactoring.getPages()) {
                    this.pages.add(aktPage);
                }
            }
        }
    }
}

