/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movemethod;

import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.MoveMethodConfig;
import org.rubypeople.rdt.refactoring.editprovider.ReplaceEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;

public class DelegateMethodEditProvider
extends ReplaceEditProvider {
    private MoveMethodConfig config;
    private Node scopePos;
    private MethodNodeWrapper oldMethod;

    public DelegateMethodEditProvider(MoveMethodConfig config) {
        super(false);
        this.config = config;
        this.oldMethod = config.getMethodNode();
        this.scopePos = NodeProvider.unwrap(this.oldMethod.getBodyNode());
    }

    protected int getOffsetLength() {
        return this.getExtendedPosition(this.scopePos).getEndOffset() - this.getExtendedPosition(this.scopePos).getStartOffset();
    }

    protected Node getEditNode(int offset, String document) {
        Node methodCall = this.getMethodCallNode();
        return NodeFactory.createNewLineNode(methodCall);
    }

    private Node getMethodCallNode() {
        Object receiverNode = this.oldMethod.isClassMethod() ? NodeFactory.createConstNode(this.config.getDestinationClassNode().getName()) : NodeFactory.createInstVarNode(this.config.getFieldInSourceClassOfTypeDestinationClass());
        ArgsNodeWrapper argsNode = this.oldMethod.getArgsNode();
        ArrayNode arrayNode = NodeFactory.createArrayNode();
        for (String argName : argsNode.getArgsList()) {
            arrayNode.add(NodeFactory.createLocalVarNode(argName));
        }
        if (this.config.doesNewMethodNeedsReferenceToSourceClass()) {
            arrayNode.add((Node)NodeFactory.createSelfNode());
        }
        return NodeFactory.createCallNode((Node)receiverNode, this.config.getMovedMethodName(), (Node)(arrayNode.size() == 0 ? null : arrayNode));
    }

    protected int getOffset(String document) {
        return this.getExtendedPosition(this.scopePos).getStartOffset();
    }
}

