/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movefield;

import java.util.Collection;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.encapsulatefield.EncapsulateFieldConditionChecker;
import org.rubypeople.rdt.refactoring.core.encapsulatefield.EncapsulateFieldConfig;
import org.rubypeople.rdt.refactoring.core.encapsulatefield.FieldEncapsulator;
import org.rubypeople.rdt.refactoring.core.movefield.MoveFieldConfig;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateAccessorAtSource {
    private final MoveFieldConfig config;

    public GenerateAccessorAtSource(MoveFieldConfig config) {
        this.config = config;
    }

    public Collection<EditProvider> getEditProviders() {
        EncapsulateFieldConfig fieldConfig = new EncapsulateFieldConfig(this.config.getDocumentProvider(), this.config.getPos());
        new EncapsulateFieldConditionChecker(fieldConfig);
        CustomTargetFieldEncapsulator fieldEncapsulator = new CustomTargetFieldEncapsulator(fieldConfig);
        return fieldEncapsulator.getEditProviders();
    }

    private class CustomTargetFieldEncapsulator
    extends FieldEncapsulator {
        public CustomTargetFieldEncapsulator(EncapsulateFieldConfig fieldConfig) {
            super(fieldConfig);
        }

        protected Node createGetterOrSetter(boolean writer, VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
            Node accessor = super.createGetterOrSetter(writer, visibility);
            INameNode targetNode = (INameNode)NodeProvider.getSubNodes(accessor, InstVarNode.class, InstAsgnNode.class).iterator().next();
            if (targetNode instanceof InstVarNode) {
                ((InstVarNode)targetNode).setName(String.valueOf(GenerateAccessorAtSource.this.config.getTargetReference()) + '.' + targetNode.getName().substring(1));
            } else {
                ((InstAsgnNode)targetNode).setName(String.valueOf(GenerateAccessorAtSource.this.config.getTargetReference()) + '.' + targetNode.getName().substring(1));
            }
            return accessor;
        }
    }
}

