/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.mergewithexternalclassparts;

import java.util.ArrayList;
import java.util.Collection;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.mergewithexternalclassparts.ClassInsertProvider;
import org.rubypeople.rdt.refactoring.core.mergewithexternalclassparts.ClassPartTreeItem;
import org.rubypeople.rdt.refactoring.core.mergewithexternalclassparts.MergeWithExternalClassPartConfig;
import org.rubypeople.rdt.refactoring.editprovider.DeleteEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiFileEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.IChildrenProvider;
import org.rubypeople.rdt.refactoring.ui.IItemSelectionReceiver;
import org.rubypeople.rdt.refactoring.ui.TreeContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalClassPartsMerger
extends TreeContentProvider
implements IItemSelectionReceiver,
IMultiFileEditProvider {
    private ArrayList<MergeTreeClassItem> treeItems;
    private String activeFile;
    private MergeWithExternalClassPartConfig config;
    private Object[] checkedElements;

    public ExternalClassPartsMerger(MergeWithExternalClassPartConfig config) {
        this.config = config;
        this.activeFile = config.getDocumentProvider().getActiveFileName();
        this.initClassesTree(config.getClassNodeProvider());
    }

    private void initClassesTree(ClassNodeProvider classesProvider) {
        this.treeItems = new ArrayList();
        Collection<ClassNodeWrapper> classes = classesProvider.getAllClassNodes();
        for (ClassNodeWrapper currentClassNode : classes) {
            this.addTreeItem(currentClassNode);
        }
    }

    private void addTreeItem(ClassNodeWrapper classWrapper) {
        Collection<PartialClassNodeWrapper> classParts = classWrapper.getPartialClassNodes();
        Collection<PartialClassNodeWrapper> localParts = classWrapper.getPartialClassNodesOfFile(this.activeFile);
        classParts.removeAll(localParts);
        if (!classParts.isEmpty()) {
            for (PartialClassNodeWrapper currentClassPart : localParts) {
                this.treeItems.add(new MergeTreeClassItem(currentClassPart, classWrapper));
            }
        }
    }

    @Override
    public Collection<FileMultiEditProvider> getFileEditProviders() {
        MultiFileEditProvider multiProvider = new MultiFileEditProvider();
        Object[] objectArray = this.checkedElements;
        int n = this.checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                FileEditProvider editProvider;
                block3: {
                    Object item;
                    block2: {
                        item = objectArray[n2];
                        editProvider = null;
                        if (!(item instanceof MergeTreeFileItem)) break block2;
                        MergeTreeFileItem fileItem = (MergeTreeFileItem)item;
                        editProvider = new FileEditProvider(fileItem.toString(), fileItem);
                        if (fileItem.getInsertedNodeWrapper().getClassBodyNode() != null) break block3;
                        break block4;
                    }
                    if (item instanceof MergeTreeClassItem) {
                        MergeTreeClassItem classItem = (MergeTreeClassItem)item;
                        editProvider = new FileEditProvider(classItem.getPath(), classItem);
                    }
                }
                multiProvider.addEditProvider(editProvider);
            }
            ++n2;
        }
        return multiProvider.getFileEditProviders();
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.treeItems.toArray();
    }

    @Override
    public void setSelectedItems(Object[] checkedElements) {
        this.checkedElements = (Object[])checkedElements.clone();
        this.config.setSelectionEmpty(checkedElements.length == 0);
    }

    public ArrayList<MergeTreeClassItem> getTreeItems() {
        return this.treeItems;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MergeTreeClassItem
    extends DeleteEditProvider
    implements IChildrenProvider,
    ClassPartTreeItem {
        PartialClassNodeWrapper classPart;
        ClassNodeWrapper wholeClass;
        ArrayList<MergeTreeFileItem> classParts;

        public MergeTreeClassItem(PartialClassNodeWrapper classPart, ClassNodeWrapper wholeClass) {
            super(classPart.getWrappedNode());
            this.classPart = classPart;
            this.wholeClass = wholeClass;
            this.initClassParts();
        }

        private void initClassParts() {
            this.classParts = new ArrayList();
            Collection<PartialClassNodeWrapper> partialClasses = this.wholeClass.getPartialClassNodes();
            for (PartialClassNodeWrapper currentClassPart : partialClasses) {
                String file = currentClassPart.getWrappedNode().getPosition().getFile();
                if (ExternalClassPartsMerger.this.activeFile.equals(file)) continue;
                this.classParts.add(new MergeTreeFileItem(currentClassPart, this.classPart));
            }
        }

        @Override
        public Object[] getChildren() {
            return this.classParts.toArray();
        }

        public Collection<MergeTreeFileItem> getClassParts() {
            return this.classParts;
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        private String getPath() {
            return ExternalClassPartsMerger.this.config.getDocumentProvider().getActiveFileName();
        }

        public String toString() {
            return this.classPart.getClassName();
        }

        @Override
        public PartialClassNodeWrapper getClassPartWrapper() {
            return this.classPart;
        }
    }

    public static class MergeTreeFileItem
    extends ClassInsertProvider
    implements ClassPartTreeItem {
        private PartialClassNodeWrapper classNode;
        private PartialClassNodeWrapper insertedNode;

        public MergeTreeFileItem(PartialClassNodeWrapper classNode, PartialClassNodeWrapper classPart) {
            super(classPart.getClassBodyNode(), classNode);
            this.classNode = classNode;
            this.insertedNode = classPart;
        }

        public String toString() {
            return this.classNode.getWrappedNode().getPosition().getFile();
        }

        public PartialClassNodeWrapper getClassPartWrapper() {
            return this.classNode;
        }

        public PartialClassNodeWrapper getInsertedNodeWrapper() {
            return this.insertedNode;
        }
    }
}

