/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinemethod;

import java.util.Collection;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.inlinemethod.ITargetClassFinder;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NameHelper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class TargetClassFinder
implements ITargetClassFinder {
    public String findTargetClass(MethodCallNodeWrapper call, IDocumentProvider doc) {
        AssignableNode type;
        String name = "";
        if (call.getReceiverNode() == null) {
            name = this.getSurroundingClass(call, doc);
        }
        if (this.createsNewInstance(type = this.getAssignableNode(call, doc))) {
            Node receiver = ((CallNode)type.getValueNode()).getReceiverNode();
            name = NameHelper.getFullyQualifiedName(receiver);
        }
        return name;
    }

    private String getSurroundingClass(MethodCallNodeWrapper call, IDocumentProvider doc) {
        ClassNode classNode = (ClassNode)NodeProvider.getEnclosingNodeOfType((Node)doc.getActiveFileRootNode(), call.getWrappedNode(), ClassNode.class);
        if (classNode != null) {
            return classNode.getCPath().getName();
        }
        return "";
    }

    private AssignableNode getAssignableNode(MethodCallNodeWrapper call, IDocumentProvider doc) {
        LocalAsgnNode receiverType = null;
        if (call.getReceiverNode() instanceof LocalVarNode) {
            receiverType = this.localAsgnFromLocalVar((LocalVarNode)call.getReceiverNode(), doc);
        } else if (call.getReceiverNode() instanceof InstVarNode) {
            receiverType = this.instVarFromCall((InstVarNode)call.getReceiverNode(), doc);
        }
        return receiverType;
    }

    private boolean createsNewInstance(AssignableNode receiverType) {
        return receiverType != null && receiverType.getValueNode() instanceof CallNode && "new".equals(((CallNode)receiverType.getValueNode()).getName());
    }

    public InstAsgnNode instVarFromCall(InstVarNode node, IDocumentProvider doc) {
        InstAsgnNode decoratedNode = null;
        try {
            ClassNodeWrapper selectedClassNode = SelectionNodeProvider.getSelectedClassNode((Node)doc.getActiveFileRootNode(), node.getPosition().getStartOffset());
            ClassNodeWrapper allClassNodes = new ClassNodeProvider(doc).getClassNode(selectedClassNode.getName());
            if (allClassNodes == null) {
                throw new NoClassNodeException();
            }
            for (FieldNodeWrapper field : allClassNodes.getFields()) {
                if (!field.getName().equals(node.getName()) || field.getNodeType() != 1) continue;
                decoratedNode = (InstAsgnNode)field.getWrappedNode();
            }
        }
        catch (NoClassNodeException noClassNodeException) {
            decoratedNode = this.findInstVarInScope(node, doc, null);
        }
        return decoratedNode;
    }

    private InstAsgnNode findInstVarInScope(InstVarNode node, IDocumentProvider doc, InstAsgnNode decoratedNode) {
        Collection<Node> assignments = NodeProvider.getSubNodes((Node)doc.getActiveFileRootNode(), InstAsgnNode.class);
        for (Node assignment : assignments) {
            if (!((InstAsgnNode)assignment).getName().equals(node.getName()) || assignment.getPosition().getStartOffset() >= node.getPosition().getStartOffset()) continue;
            decoratedNode = (InstAsgnNode)assignment;
        }
        return decoratedNode;
    }

    public LocalAsgnNode localAsgnFromLocalVar(LocalVarNode node, IDocumentProvider doc) {
        Node enclosingScope = SelectionNodeProvider.getEnclosingScope((Node)doc.getActiveFileRootNode(), (Node)node);
        LocalAsgnNode asgnNode = this.findLastAssignmentToVar(node, NodeUtil.getBody(enclosingScope));
        if (asgnNode != null) {
            return asgnNode;
        }
        do {
            enclosingScope = SelectionNodeProvider.getEnclosingScope((Node)doc.getActiveFileRootNode(), NodeProvider.findParentNode((Node)doc.getActiveFileRootNode(), enclosingScope));
            asgnNode = this.findLastAssignmentToVar(node, NodeUtil.getBody(enclosingScope));
        } while (!(enclosingScope instanceof RootNode) && !(enclosingScope instanceof MethodDefNode) && asgnNode == null);
        return asgnNode;
    }

    private LocalAsgnNode findLastAssignmentToVar(LocalVarNode node, Node enclosingScope) {
        LocalAsgnNode localAsgnNode = null;
        for (LocalAsgnNode asgnNode : NodeProvider.gatherLocalAsgnNodes(enclosingScope)) {
            if (asgnNode.getIndex() != node.getIndex() || !asgnNode.getName().equals(node.getName()) || asgnNode.getPosition().getStartOffset() >= node.getPosition().getStartOffset()) continue;
            localAsgnNode = asgnNode;
        }
        return localAsgnNode;
    }
}

